#include <stdlib.h>
#include <stdio.h>
#include <semaphore.h>
#include "ts_queue.h"

#define MAX_SIZE 100


sem_t mutex_sem;
sem_t free_sem;
sem_t busy_sem;


typedef struct queue {
  int queue_val[MAX_SIZE];
  int rear;
  int front;
  int max_queue_size;
} queue;

queuep CreateQ(int size) {
  queuep Q;
  if (size+1 > MAX_SIZE) {
    printf("Cannot create a queue so large\n");
    size = MAX_SIZE-1;
  }
  sem_init(&mutex_sem, 0, 1);
  sem_init(&free_sem, 0, size);
  sem_init(&busy_sem, 0, 0);
  Q = (queuep) malloc(sizeof(struct queue));
  Q->rear = Q->front = 0;
  Q->max_queue_size = size+1;
  return Q;
}

void ShowQ(queuep Q) {
  int i;

  printf("queue: [");
  if (Q->front == Q->rear)
    printf("]\n");
  else {
    i = (Q->front+1)%(Q->max_queue_size);
    for (;; i = (i+1)%(Q->max_queue_size)) {
      printf("%d", Q->queue_val[i]);
      if (i == Q->rear) {
	printf("]\n");
	break;
      }
      else
	printf(", ");
    }
  }
}

void DisplayQ(queuep Q) {
  sem_wait(&mutex_sem);
  ShowQ(Q);
  sem_post(&mutex_sem);
}

void InsertQ(queuep Q, int e) {
  sem_wait(&free_sem);
  sem_wait(&mutex_sem);
  Q->rear = (Q->rear+1)%(Q->max_queue_size);
  Q->queue_val[Q->rear] = e;
  printf("+ %d -> ", e); ShowQ(Q);
  sem_post(&mutex_sem);
  sem_post(&busy_sem);
}

int  ExtractQ(queuep Q) {
  int item;
  sem_wait(&busy_sem);
  sem_wait(&mutex_sem);
    item = (Q->queue_val[((Q->front)+1)%(Q->max_queue_size)]);
    Q->front = (Q->front+1)%(Q->max_queue_size);
  printf("- %d -> ", item); ShowQ(Q);
  sem_post(&mutex_sem);
  sem_post(&free_sem);
}



