#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define MAX_CONN 5
#define SERVER_PUBLIC_PORT 3555
#define MAX_LUN (16)

#define DEBUG 1

void addr_initialize(struct sockaddr_in *sa, int port, u_long IPaddr) {
  bzero((void *) sa, sizeof(struct sockaddr_in));
  sa->sin_family = AF_INET;
  sa->sin_port = htons((u_short)port);
  sa->sin_addr.s_addr = IPaddr;
}

int main (int argc, char *argv[]) {
  int public_sd, private_sd;
  struct sockaddr_in server_addr, client_addr;
  int server_lun = sizeof(server_addr);
  int client_lun = sizeof(client_addr);
  int i, num;
  char com, buf[MAX_LUN];

  addr_initialize(&server_addr, SERVER_PUBLIC_PORT, htonl(INADDR_ANY));

  public_sd = socket(AF_INET,SOCK_STREAM, 0);
  bind(public_sd, (struct sockaddr *) &server_addr, (socklen_t) server_lun);
  listen(public_sd, MAX_CONN);
  if ((private_sd = accept(public_sd, (struct sockaddr *) &client_addr, &client_lun)) <0)
      printf("Server> accept KO\n");
  else {
      printf("Server> accept OK\n");
      printf("Server> connected with client %s, port %i\n", inet_ntoa(client_addr.sin_addr.s_addr),
             ntohs(client_addr.sin_port));
      while(1) {
        for (i = 0; i < MAX_LUN; i++) {
           num = recv(private_sd, &buf[i], 1, 0);
           if (num<1) {
             close(private_sd);
             close(public_sd);
             exit(0);
           }
           printf("%c", buf[i]);
           if (buf[i] == '\0') break;
        }
        printf(" [server]\n", buf);
      }
  }
  close(public_sd);
  exit(0);
}




