#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define MAX_CONN 5
// MAX_CONN = number of slots in buffer
#define SERVER_PUBLIC_PORT 3555
#define MAX_LUN (16)

#define DEBUG 1

#define GO_RANDOM 1

void spend_time(long int n, long int m) {
  int a, b, c;
  long int i, j;
#ifdef GO_RANDOM
  n = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
  m = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
#endif
//  printf("attesa di %ld, %ld\n",m,n);
  for (i=0; i<n; i++)
    for (j=0; j<m; j++) {
      a = b;
      b = c;
      c = a;
  }
}



void addr_initialize(struct sockaddr_in *sa, int port, u_long IPaddr) {
  bzero((void *) sa, sizeof(struct sockaddr_in));
  sa->sin_family = AF_INET;
  sa->sin_port = htons((u_short)port);
  sa->sin_addr.s_addr = IPaddr;
}

int main (int argc, char *argv[]) {
  int public_sd, private_sd;
  struct sockaddr_in server_addr, client_addr;
  int server_lun = sizeof(server_addr);
  int client_lun = sizeof(client_addr);
  int i, num;
  char com, buf[MAX_LUN];

  addr_initialize(&server_addr, SERVER_PUBLIC_PORT, htonl(INADDR_ANY));

  public_sd = socket(AF_INET,SOCK_STREAM, 0);
  bind(public_sd, (struct sockaddr *) &server_addr, (socklen_t) server_lun);
  listen(public_sd, MAX_CONN);
  if ((private_sd = accept(public_sd, (struct sockaddr *) &client_addr, &client_lun)) <0)
      printf("Consumer> accept KO\n");
  else {
      printf("Consumer> accept OK\n");
//      printf("Server> connected with client %s, port %i\n", inet_ntoa(client_addr.sin_addr.s_addr), ntohs(client_addr.sin_port));
      for (i = 0; i < MAX_CONN; i++) {
        if (send(private_sd, "empty_msg", 10, 0) != 10) {
          printf("Consumer> Errore nell'invio al server del messaggio empty.\n");
          exit(1);
        }
      }
      while(1) {
        for (i = 0; i < MAX_LUN; i++) {
           num = recv(private_sd, &buf[i], 1, 0);
           if (num<1) {
             close(private_sd);
             close(public_sd);
             exit(0);
           }
           if (buf[i] == '\0') break;
        }
        printf("[consumo] %s \n", buf);
        if (send(private_sd, "empty_msg", 10, 0) != 10) {
          printf("Consumer> Errore nell'invio al server del messaggio empty.\n");
          exit(1);
        }
        spend_time(1, 100);
      }
  }
  close(public_sd);
  exit(0);
}




