#include <stdlib.h>
#include <stdio.h>
#include "queue.h"

#define MAX_SIZE 100

typedef struct queue {
  int queue_val[MAX_SIZE];
  int rear;
  int front;
  int max_queue_size;
} queue;

queuep CreateQ(int size) {
  queuep Q;
  if (size+1 > MAX_SIZE) {
    printf("Cannot create a queue so large\n");
    size = MAX_SIZE-1;
  }
  Q = (queuep) malloc(sizeof(struct queue));
  Q->rear = Q->front = 0;
  Q->max_queue_size = size+1;
  return Q;
}

int IsEmptyQ(queuep Q) {
  return (Q->front == Q->rear);
}

int IsFullQ(queuep Q) {
  return (Q->front ? Q->front == Q->rear+1 : Q->rear == Q->max_queue_size-1);
}

void DisplayQ(queuep Q) {
  int i;

  printf("queue: [");
  if (IsEmptyQ(Q))
    printf("]\n");
  else {
    i = (Q->front+1)%(Q->max_queue_size);
    for (;; i = (i+1)%(Q->max_queue_size)) {
      printf("%d", Q->queue_val[i]);
      if (i == Q->rear) {
	printf("]\n");
	break;
      }
      else
	printf(", ");
    }
  }
}

queuep InsertQ(queuep Q, int e) {
  if (IsFullQ(Q)) {
    printf("Cannot add: queue full\n");
    return Q;
  }
  Q->rear = (Q->rear+1)%(Q->max_queue_size);
  Q->queue_val[Q->rear] = e;
  return Q;
}

queuep RemoveQ(queue *Q) {
  if (IsEmptyQ(Q)) {
    printf("Cannot delete: queue empty\n");
    return Q;
  }
  Q->front = (Q->front+1)%(Q->max_queue_size);
  return Q;
}

int  FrontElement(queuep Q) {
  if (IsEmptyQ(Q)) {
    fprintf(stderr, "cannot return item: queue empty\n");
  }
  else {
    return (Q->queue_val[((Q->front)+1)%(Q->max_queue_size)]);
  }
}

