#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "queue.h"

#define BUF_SIZE (4)
#define GO_RANDOM 1

pthread_mutex_t mutex_sem;
pthread_cond_t c_free;
pthread_cond_t c_busy;
int g_count = 0; // number of items in the buffer. It is a global variable.

void spend_time(long int n, long int m) {
  int a, b, c;
  long int i, j;
#ifdef GO_RANDOM
  n = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
  m = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
#endif
//  printf("attesa di %ld, %ld\n",m,n);
  for (i=0; i<n; i++)
    for (j=0; j<m; j++) {
      a = b;
      b = c;
      c = a;
  }
}

void * prod (void *pv) {
  queuep *pQ = pv;
  queuep Q = *pQ;
  int item = 0;
  for (;;) {
    spend_time(1,100);
    item++;
    pthread_mutex_lock(&mutex_sem);
    while (g_count==BUF_SIZE) {
      pthread_cond_wait(&c_free, &mutex_sem);  // rilascia lock su mutex e si sospende su cond. free
    }
      DisplayQ(Q);
      printf(" + %d -> ", item);
      InsertQ(Q, item);
      g_count++;
      DisplayQ(Q);
    pthread_mutex_unlock(&mutex_sem);
    if(pthread_cond_signal(&c_busy)) printf("Producer: errore da signal\n");
  }
  return NULL;
}


void * cons (void *pv) {
  queuep *pQ = pv;
  queuep Q = *pQ;
  int item;
  for (;;) {
    pthread_mutex_lock(&mutex_sem);
    while(g_count==0) {
      pthread_cond_wait(&c_busy, &mutex_sem);  // rilascia lock su mutex e si sospende su cond. free
    }
    DisplayQ(Q);
    item = FrontElement(Q);
    RemoveQ(Q);
    g_count--;
    printf(" - %d -> ", item);
    DisplayQ(Q);
    pthread_mutex_unlock(&mutex_sem);
    if(pthread_cond_signal(&c_free)) printf("Producer: errore da signal\n");
    spend_time(1,100);
  }
  return NULL;
}


int main() {
  pthread_t id0, id1;
  int err;
  void * retval;
  queuep Q;



//  sem_init(&mutex_sem, 0, 1);

//  sem_init(&free_sem, 0, BUF_SIZE);
//  sem_init(&busy_sem, 0, 0);
  Q = CreateQ(BUF_SIZE);
  DisplayQ(Q);
  printf("Inizio!\n");
  err = pthread_create(&id0, NULL, prod, &Q);
  err = pthread_create(&id1, NULL, cons, &Q);
  pthread_join(id0, &retval); /* il padrea aspetta i figli */
  pthread_join(id1, &retval);
  return 0;
}
