#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <semaphore.h>

#include "queue.h"

#define BUF_SIZE (3)
#define GO_RANDOM 1

sem_t mutex_sem;
sem_t free_sem;
sem_t busy_sem;

void spend_time(long int n, long int m) {
  int a, b, c;
  long int i, j;
#ifdef GO_RANDOM
  n = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
  m = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
#endif
//  printf("attesa di %ld, %ld\n",m,n);
  for (i=0; i<n; i++)
    for (j=0; j<m; j++) {
      a = b;
      b = c;
      c = a;
  }
}


void * prod (void *pv) {
  queuep *pQ = pv;
  queuep Q = *pQ;
  int item = 0;
  for (;;) {
//    sleep(1);
    spend_time(1,100);
    sem_wait(&free_sem);
    sem_wait(&mutex_sem);
      DisplayQ(Q);
      item++;
      printf(" + %d -> ", item);
      InsertQ(Q, item);
      DisplayQ(Q);
    sem_post(&mutex_sem);
    sem_post(&busy_sem);
  }
  return NULL;
}


void * cons (void *pv) {
  queuep *pQ = pv;
  queuep Q = *pQ;
  int item;
  for (;;) {
    sem_wait(&mutex_sem);   // ERRORE !!!!
    sem_wait(&busy_sem);
      DisplayQ(Q);
      item = FrontElement(Q);
      RemoveQ(Q);
      printf(" - %d -> ", item);
      DisplayQ(Q);
    sem_post(&mutex_sem);
    sem_post(&free_sem);
    spend_time(1,100);
  }
  return NULL;
}


int main() {
  pthread_t id0, id1;
  int err;
  void * retval;
  queuep Q;



  sem_init(&mutex_sem, 0, 1);
  sem_init(&free_sem, 0, BUF_SIZE);
  sem_init(&busy_sem, 0, 0);
  Q = CreateQ(BUF_SIZE);
  DisplayQ(Q);
  printf("Inizio!\n");
  err = pthread_create(&id0, NULL, prod, &Q);
  err = pthread_create(&id1, NULL, cons, &Q);
  pthread_join(id0, &retval); /* il padrea aspetta i figli */
  pthread_join(id1, &retval);
  return 0;
}
