#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <semaphore.h>

#define NREADER  (3)
#define NWRITER  (2)

sem_t mutex_sem;
sem_t db_sem;
int g_rc = 0;

void spend_time() {
  long int n, m, i, j;
  int a, b, c;
  n = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
  m = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
  for (i=0; i<n; i++)
    for (j=0; j<m; j++) {
      a = b;
      b = c;
      c = a;
  }
}

void read_db(int n) {
  printf("lettore %d inizia lettura\n", n);
  spend_time();
  printf("lettore %d conclude lettura\n", n);
}

void write_db(int n) {
  printf("scrittore %d inizia scrittura\n", n);
  spend_time();
  printf("scrittore %d conclude scrittura\n", n);
}

void * reader (void *pv) {
  int *pi = (int *) pv;
  int i = *pi;
  for (;;) {
    spend_time();
    sem_wait(&mutex_sem);
    g_rc++;
    if(g_rc==1) {
      sem_wait(&db_sem);
    }
    sem_post(&mutex_sem);

    read_db(i);

    sem_wait(&mutex_sem);
    g_rc--;
    if(g_rc==0) {
      sem_post(&db_sem);
    }
    sem_post(&mutex_sem);
  }
  return NULL;
}

void * writer (void *pv) {
  int *pi = (int *) pv;
  int i = *pi;
  for (;;) {
    spend_time();
    sem_wait(&db_sem);
    write_db(i);
    sem_post(&db_sem);
  }
  return NULL;
}


int main() {
  pthread_t idr[3], idw[2];
  int err, i, nr[NREADER], nw[NWRITER];
  void * retval;

  sem_init(&mutex_sem, 0, 1);
  sem_init(&db_sem, 0, 1);
  printf("Inizio!\n");
  for (i=0; i<NWRITER; i++) {
    nw[i] = i;
    err = pthread_create(&idw[i], NULL, writer, &nw[i]);
  }
  for (i=0; i<NREADER; i++) {
    nr[i] = i;
    err = pthread_create(&idr[i], NULL, reader, &nr[i]);
  }
  for (i=0; i<NREADER; i++) {
     pthread_join(idr[i], &retval);
  }
  for (i=0; i<NWRITER; i++) {
     pthread_join(idw[i], &retval);
  }
  return 0;
}
