#include <stdlib.h>
#include <stdio.h>
#include <semaphore.h>
#include <pthread.h>

#define NUM_PHIL (5)
#define LEFT     ((i+NUM_PHIL-1) % NUM_PHIL)
#define RIGHT    ((i+1)   % NUM_PHIL)
#define THINKING 0
#define HUNGRY   1
#define EATING   2

int state[NUM_PHIL];

sem_t mutexs;
sem_t s[NUM_PHIL];

void passa_il_tempo() {
 long int n, m, i, j;
  int a, b, c;
  n = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
  m = 1 + (int) (9999.99 * (rand() / (RAND_MAX + 1.0)));
  for (i=0; i<n; i++)
    for (j=0; j<m; j++) {
      a = b;
      b = c;
      c = a;
  }
}

void think (int np) {
  printf("phil.%d starts thinking\n", np);
  passa_il_tempo();
  printf("phil.%d stops thinking\n", np);
}

void eat(int np) {
  printf("phil.%d starts eating\n", np);
  passa_il_tempo();
  printf("phil.%d stops eating\n", np);
}

void test(int i) {
  if (HUNGRY == state[i] &&
      EATING != state[LEFT] && EATING != state[RIGHT])
  {
    state[i] = EATING;
    sem_post(&s[i]);
  }
}

void take_forks(int i) {
  sem_wait(&mutexs);
  state[i] = HUNGRY;
  test(i);
  sem_post(&mutexs);
  sem_wait(&s[i]);
}

void put_forks(int i) {
  sem_wait(&mutexs);
  state[i] = THINKING;
  test(LEFT);
  test(RIGHT);
  sem_post(&mutexs);
}


void *philosopher(void *pv) {
  int i, *pi;
  pi = (int *) pv;
  i = *pi;
  while (1) {
    think(i);
    take_forks(i);
    eat(i);
    put_forks(i);
  }
}


main() {
  int i, pnum[NUM_PHIL];
  pthread_t idt[NUM_PHIL];
  int err;
  void * retval;

  // inizializza mutex a 1 e s[i] a 0;
  sem_init(&mutexs, 0, 1);
  for(i=0; i<NUM_PHIL; i++)
    sem_init(&s[i], 0, 0);
//  printf("Inizio!\n");
  for(i=0; i<NUM_PHIL; i++) {
    pnum[i] = i;
    err = pthread_create(&idt[i], NULL, philosopher, &pnum[i]);
  }
  /* il padrea aspetta i figli */
  for(i=0; i<NUM_PHIL; i++) {
    pthread_join(idt[i], &retval);
   }
  return 0;
}
