#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#define N 4   /* numero di processi da sincronizzare */

pthread_mutex_t mutex;
pthread_mutex_t mutex1;
pthread_cond_t all_arrived;
pthread_cond_t all_departed;

int count = 0;              /* numero di processi fermi alla barriera */
int direction = 0;
int pdir[N];
int sleep_time[N] = {1, 1, 2, 2};


void check_dir(int nt) {
  printf("Figlio %d alla verifica dir. (mia=%d, bar=%d)\n", nt, pdir[nt], direction);
  pthread_mutex_lock(&mutex1);
  if(direction != pdir[nt]) {
    printf("Figlio %d bloccato alla verifica dir.\n", nt);
    pthread_cond_wait(&all_departed, &mutex1);
    printf("Figlio %d sbloccato dalla verifica dir.\n", nt);

  }
  pthread_mutex_unlock(&mutex1);
}


void my_barrier(int nt) {
  printf("Figlio %d alla barriera\n", nt);
  pthread_mutex_lock(&mutex);
  count++;
  if (count==N) {
    count--;
    pthread_mutex_unlock(&mutex);
    if(pthread_cond_broadcast(&all_arrived)) printf("Figlio %d riceve errore da signal\n", nt);
    printf("Figlio %d esce dalla barriera\n", nt);
  }
  else {
    printf("Figlio %d fa wait\n", nt);
    pthread_cond_wait(&all_arrived,&mutex);  /* rilascia lock su mutex e si sospende su cond. all_arrived */
    /* riprende implicitamente il lock su mutex all'uscita da wait */
    count--;
    printf("Figlio %d esce dalla barriera [count = %d]\n", nt, count);
    if (count > 0) {
      pthread_mutex_unlock(&mutex);
//      pthread_cond_broadcast(&all_arrived); /* inutile: con broadcast precedente sono gia' stati svegliati tutti i proc. in barriera */
    }
    else {
      direction = 1 - direction;
      printf("Figlio %d cambia direzione alla barriera [dir = %d]\n", nt, direction);
      pthread_mutex_unlock(&mutex);
      pthread_mutex_unlock(&mutex1);
      pthread_cond_broadcast(&all_departed);
    }
  }
}





void * fn (void *pv) {
  char * msg = pv;
  int j=0; int nt = (int)(msg[0] - '0');
  while(j<3) {
    printf("Figlio %d a inizio ciclo con direz. %d\n", nt, pdir[nt]);
//    sleep(2*(N+1-nt));
    if ((nt/2)*2==nt)
      sleep(sleep_time[nt]);
    check_dir(nt);
    printf("Figlio %d a meta' ciclo. %d\n", nt);
    my_barrier(nt);
    pdir[nt] = 1 - pdir[nt];
    j++;
  }
  printf("Figlio %d termina\n", nt);
  return NULL;
}




int main() {
  pthread_t id[N];
  int i, err;
  char pstr[N][3];
  void * retval;
  printf("Parto!\n");
  for (i=0; i<N; i++) {
     strcpy(pstr[i], "N ");
     pstr[i][0] = (char)i+'0';
     printf("Lancio figlio %s\n", pstr[i]);
     err = pthread_create(&id[i], NULL, fn, pstr[i]);
  }
  for (i=0; i<N; i++)
     pthread_join(id[i], &retval);
  return 0;
}




