#include <pthread.h>
#include <semaphore.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define N 4   /* numero di processi da sincronizzare */

pthread_mutex_t mutex;
sem_t bar_sem;
sem_t dir_sem;

int count = 0, dir_count = 0; 
int direction = 0;
int pdir[N];

void check_dir(int nt) {
  printf("Figlio %d alla verifica dir. (mia=%d, bar=%d)\n", nt, pdir[nt], direction);
  pthread_mutex_lock(&mutex);
  if(direction != pdir[nt]) {
    dir_count++;
    pthread_mutex_unlock(&mutex);
    printf("Figlio %d bloccato alla verifica dir.\n", nt);
    sem_wait(&dir_sem);
    printf("Figlio %d sbloccato dalla verifica dir.\n", nt);
    pthread_mutex_lock(&mutex);
    dir_count--;
    if(dir_count)
      sem_post(&dir_sem);
  }
  else
    pthread_mutex_unlock(&mutex);
  
}

void my_barrier(char *msg) {
  printf("Figlio %s alla barriera\n", msg);
  pthread_mutex_lock(&mutex);
  count++;
  if (count==N) {
    count--;
    printf("Figlio %s esce dalla barriera\n", msg);
    sem_post(&bar_sem);
    pthread_mutex_unlock(&mutex);
  }
  else {
    printf("Figlio %s fa wait\n", msg);
    pthread_mutex_unlock(&mutex);
    sem_wait(&bar_sem);
    printf("Figlio %s esce dalla barriera\n", msg);
    pthread_mutex_lock(&mutex);
    count--;
    if (count > 0) {
      sem_post(&bar_sem);
    }
    else {
      direction = 1 - direction;
      if(dir_count)
        sem_post(&dir_sem);
    }
    pthread_mutex_unlock(&mutex);
  }
}

void * fn (void *pv) {
  char * msg = pv;
  int j=0; int nt = (int)(msg[0] - '0');
  while(j<3) {
    printf("Figlio %d a inizio ciclo con direz. %d\n", nt, pdir[nt]);
    sleep(nt);
    check_dir(nt);
    my_barrier(msg);
    pdir[nt] = 1 - pdir[nt];
    j++;
  }
  printf("Figlio %d termina\n", nt);
  return NULL;
}

int main() {
  pthread_t id[N];
  int i, err;
  char pstr[N][3];
  void * retval;

  for (i=0; i<N; i++) pdir[i] = 0;

  i = sem_init(& bar_sem, 0, 0);
  if (i!=0) {
    printf("Fallita inizializzazione semaforo barriera!\n");
    exit(0);
  }
  i = sem_init(& dir_sem, 0, 0);
  if (i!=0) {
    printf("Fallita inizializzazione semaforo direzione!\n");
    exit(0);
  }

  printf("Parto!\n");
  for (i=0; i<N; i++) {
     strcpy(pstr[i], "N ");
     pstr[i][0] = (char)i+'0';
     printf("Lancio figlio %s\n", pstr[i]);
     err = pthread_create(&id[i], NULL, fn, pstr[i]);
  }
  for (i=0; i<N; i++)
     pthread_join(id[i], &retval);
  return 0;
}





/*

semaphore mutex = 1;
semaphore halt = 0;

int count = 0;

void process_x() {

  .....

  down(mutex);
  count++;
  if (count==N) {
    count--;
    up(halt);
    up(mutex);
  }
  else {
    up(mutex);
    down(halt);
    down(mutex); 
    count--;
    if (count > 0) {
      up(halt);
      up(mutex);
    }
  }

  ....

*/


