#include <pthread.h>   /* usiamo libreria pthread */
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#define N 4   /* numero di processi da sincronizzare */

pthread_mutex_t mutex;
pthread_cond_t all_arrived;

int count = 0; 

void my_barrier(char *msg) {
  printf("Figlio %s alla barriera\n", msg);
  pthread_mutex_lock(&mutex);
  count++;
  if (count==N) {
    count--;
    pthread_mutex_unlock(&mutex);
    if(pthread_cond_signal(&all_arrived)) printf("Figlio %s riceve errore da signal\n", msg);
    printf("Figlio %s esce dalla barriera\n", msg);
  }
  else {
    printf("Figlio %s fa wait\n", msg);
    pthread_cond_wait(&all_arrived,&mutex);  /* rilascia lock su mutex e si sospende su cond. all_arrived */
    /* pthread_mutex_lock(&mutex); */
    count--;
    printf("Figlio %s esce dalla barriera\n", msg);
    if (count > 0) {
      pthread_mutex_unlock(&mutex);
      if(pthread_cond_signal(&all_arrived)) printf("Figlio %s riceve errore da signal\n", msg);
    }
  }
}

void * fn (void *pv) {
  char * msg = pv;
  printf("Figlio %s\n", msg);
  sleep(2);
  my_barrier(msg);
  printf("Figlio %s termina\n", msg);
  return NULL;
}

int main() {
  pthread_t id[N];
  int i, err;
  char pstr[N][3];
  void * retval;
  printf("Parto!\n");
  for (i=0; i<N; i++) {
     strcpy(pstr[i], "N ");
     pstr[i][0] = (char)i+'0';
     printf("Lancio figlio %s\n", pstr[i]);
     err = pthread_create(&id[i], NULL, fn, pstr[i]);
  }
  for (i=0; i<N; i++)
     pthread_join(id[i], &retval);
  return 0;
}





/*

semaphore mutex = 1;
semaphore halt = 0;

int count = 0;

void process_x() {

  .....

  down(mutex);
  count++;
  if (count==N) {
    count--;
    up(halt);
    up(mutex);
  }
  else {
    up(mutex);
    down(halt);
    down(mutex); 
    count--;
    if (count > 0) {
      up(halt);
      up(mutex);
    }
  }

  ....

*/


