#include <pthread.h>
#include <semaphore.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define N 4   /* numero di processi da sincronizzare */

pthread_mutex_t mutex;
sem_t bar_sem;
// pthread_cond_t all_arrived;

int count = 0; 

void my_barrier(char *msg) {
  printf("Figlio %s alla barriera\n", msg);
  pthread_mutex_lock(&mutex);
  count++;
  if (count==N) {
    count--;
    printf("Figlio %s esce dalla barriera\n", msg);
    sem_post(&bar_sem);
    pthread_mutex_unlock(&mutex);
  }
  else {
    printf("Figlio %s fa wait\n", msg);
    pthread_mutex_unlock(&mutex);
    sem_wait(&bar_sem);
    printf("Figlio %s esce dalla barriera\n", msg);
    pthread_mutex_lock(&mutex);
    count--;
    if (count > 0) {
      sem_post(&bar_sem);
    }
    pthread_mutex_unlock(&mutex);
  }
}

void * fn (void *pv) {
  char * msg = pv;
  printf("Figlio %s\n", msg);
  sleep(2);
  my_barrier(msg);
  printf("Figlio %s termina\n", msg);
  return NULL;
}

int main() {
  pthread_t id[N];
  int i, err;
  char pstr[N][3];
  void * retval;

  i = sem_init(& bar_sem, 0, 0);
  if (i!=0) {
    printf("Fallita inizializzazione semaforo!\n");
    exit(0);
  }
  printf("Parto!\n");
  for (i=0; i<N; i++) {
     strcpy(pstr[i], "N ");
     pstr[i][0] = (char)i+'0';
     printf("Lancio figlio %s\n", pstr[i]);
     err = pthread_create(&id[i], NULL, fn, pstr[i]);
  }
  for (i=0; i<N; i++)
     pthread_join(id[i], &retval);
  return 0;
}





/*

semaphore mutex = 1;
semaphore halt = 0;

int count = 0;

void process_x() {

  .....

  down(mutex);
  count++;
  if (count==N) {
    count--;
    up(halt);
    up(mutex);
  }
  else {
    up(mutex);
    down(halt);
    down(mutex); 
    count--;
    if (count > 0) {
      up(halt);
      up(mutex);
    }
  }

  ....

*/


