/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Collection;
import java.util.LinkedList;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaSetOnList;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class SingleSuccedentSequentOnLists
implements _SingleSuccedentSequent,
Cloneable {
    private FormulaSetOnList[] left = new FormulaSetOnList[FormulaType.values().length];
    private Formula right;

    @Override
    public Collection<Formula> getAllLeftFormulas() {
        FormulaSetOnList set = new FormulaSetOnList();
        FormulaSetOnList[] formulaSetOnListArray = this.left;
        int n = this.left.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaSetOnList s = formulaSetOnListArray[n2];
            if (s != null) {
                set.addAll(s);
            }
            ++n2;
        }
        if (set.cardinality() == 0) {
            return null;
        }
        return set.getAllFormulas();
    }

    @Override
    public Collection<Formula> getAllLeftFormulas(FormulaType formulaType) {
        int setIndex = formulaType.ordinal();
        if (this.left[setIndex] == null) {
            return null;
        }
        return this.left[setIndex].getAllFormulas();
    }

    @Override
    public Formula getRight() {
        return this.right;
    }

    @Override
    public void addLeft(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        if (this.left[index] == null) {
            this.left[index] = new FormulaSetOnList();
            this.left[index].add(wff);
        } else if (!this.left[index].contains(wff)) {
            this.left[index].add(wff);
        }
    }

    @Override
    public void addRight(Formula wff) {
        this.right = wff;
    }

    private Formula getLeftFormula(int index) {
        if (this.left[index] != null) {
            return this.left[index].getFirst();
        }
        return null;
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        return this.getLeftFormula(formulaType.ordinal());
    }

    @Override
    public Formula getLeft() {
        FormulaSetOnList[] formulaSetOnListArray = this.left;
        int n = this.left.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaSetOnList list = formulaSetOnListArray[n2];
            if (list != null) {
                return (Formula)((LinkedList)list).getFirst();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Formula getRightFormulaOfType(FormulaType formulaType) {
        if (this.right == null) {
            return null;
        }
        if (formulaType == FormulaType.getFormulaType(this.right)) {
            return this.right;
        }
        return null;
    }

    @Override
    public boolean removeLeft(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        if (this.left[index] != null) {
            boolean result = this.left[index].remove(wff);
            if (this.left[index].cardinality() == 0) {
                this.left[index] = null;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean removeRight() {
        if (this.right != null) {
            this.right = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIdentityAxiom() {
        if (this.right == null) {
            return false;
        }
        FormulaType type = FormulaType.getFormulaType(this.right);
        int index = type.ordinal();
        return this.left[index] != null && this.left[index].contains(this.right);
    }

    @Override
    public boolean containsLeft(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        return this.left[index] != null && this.left[index].contains(wff);
    }

    @Override
    public SingleSuccedentSequentOnLists clone() {
        try {
            SingleSuccedentSequentOnLists cloned = (SingleSuccedentSequentOnLists)super.clone();
            cloned.left = new FormulaSetOnList[FormulaType.values().length];
            int i = 0;
            while (i < this.left.length) {
                if (this.left[i] != null) {
                    cloned.left[i] = this.left[i].clone();
                }
                ++i;
            }
            cloned.right = this.right;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError("Clone not supported:" + e.getMessage());
        }
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < FormulaType.values().length) {
            if (this.left[i] != null) {
                str = String.valueOf(str) + this.left[i].toString();
            }
            ++i;
        }
        return String.valueOf(str) + "==>\n" + (this.right == null ? "" : this.right.toString());
    }
}

