/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import java.io.PrintStream;
import java.util.Collection;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.Trace;
import jtabwb.engine._Prover;
import jtabwb.tracesupport.CTreeBuilder;
import jtabwb.tracesupport.CTreeLatexGenerator;
import jtabwb.tracesupport.CTreeNode;
import jtabwb.tracesupport._LatexCTreeFormatter;

public class CTree {
    private int id;
    private _Prover prover;
    private CTreeNode root;

    CTree(_Prover prover, CTreeNode root, int id) {
        this.prover = prover;
        this.root = root;
    }

    public _Prover getProver() {
        return this.prover;
    }

    public int getId() {
        return this.id;
    }

    public CTreeNode getRoot() {
        return this.root;
    }

    public ProofSearchResult getStatus() {
        return this.root.getStatus();
    }

    public static Collection<CTree> buildFrom(Trace trace) {
        CTreeBuilder builder = new CTreeBuilder(trace);
        return builder.build();
    }

    public static void toLatex(Collection<CTree> ctrees, PrintStream out, _LatexCTreeFormatter formatter) {
        CTreeLatexGenerator translator = new CTreeLatexGenerator(ctrees, formatter);
        translator.generateLatex(out);
    }

    public void toLatex(PrintStream out, _LatexCTreeFormatter formatter) {
        CTreeLatexGenerator translator = new CTreeLatexGenerator(this, formatter);
        translator.generateLatex(out);
    }
}

