/*
 * Decompiled with CFR 0.152.
 */
package ipl.rg3ied.tp;

import ipl.g3ied.evaluation.EvaluationValue;
import ipl.g3ied.evaluation.SimplificationEvaluationFactory;
import ipl.g3ied.evaluation._EvaluationFactory;
import ipl.g3ied.evaluation._Evaluator;
import ipl.g3ied.sequents.G3iFormulaFactory;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import ipl.rg3ied.calculus.RG3iClashDetectionRule;
import ipl.rg3ied.calculus.RG3iRule_Left_And;
import ipl.rg3ied.calculus.RG3iRule_Left_Or;
import ipl.rg3ied.calculus.RG3iRule_Right_And;
import ipl.rg3ied.calculus.RG3iRule_Right_Implies;
import ipl.rg3ied.calculus.RG3iRule_Right_Or_blocked;
import ipl.rg3ied.calculus.RG3iRule_Succ;
import ipl.rg3ied.tp.MetaBacktrackRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import jtabwb.engine.IterationInfo;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._Strategy;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.Formula;

class Strategy
implements _Strategy {
    _EvaluationFactory evaluation;
    private final Formula FALSE;

    public Strategy(G3iFormulaFactory factory) {
        this.FALSE = factory.getFalse();
        this.evaluation = new SimplificationEvaluationFactory();
    }

    @Override
    public _AbstractRule nextRule(_AbstractGoal node, IterationInfo lastIteration) {
        Formula mainFormula;
        _MarkedSingleSuccedentSequent premise = (_MarkedSingleSuccedentSequent)node;
        _Evaluator evaluator = this.evaluation.buildEvaluationFunction(premise);
        if (!premise.isBlocked()) {
            mainFormula = premise.getLeft(FormulaType.AND_WFF);
            if (mainFormula != null) {
                return new RG3iRule_Left_And(premise, mainFormula);
            }
            mainFormula = premise.getLeft(FormulaType.OR_WFF);
            if (mainFormula != null) {
                return new RG3iRule_Left_Or(premise, mainFormula);
            }
        }
        if ((mainFormula = premise.getRightFormulaOfType(FormulaType.IMPLIES_WFF)) != null) {
            return new RG3iRule_Right_Implies(this.evaluation, premise, mainFormula);
        }
        mainFormula = premise.getRightFormulaOfType(FormulaType.AND_WFF);
        if (mainFormula != null) {
            return new RG3iRule_Right_And(premise, mainFormula);
        }
        LinkedList<Formula> activeOr = new LinkedList<Formula>();
        mainFormula = premise.getRightFormulaOfType(FormulaType.OR_WFF);
        if (mainFormula != null) {
            Formula[] subFormulas = mainFormula.immediateSubformulas();
            int i = 0;
            while (i < subFormulas.length) {
                Formula Hi = subFormulas[i];
                if (evaluator.eval(Hi) != EvaluationValue.F) {
                    activeOr.add(Hi);
                }
                ++i;
            }
        }
        if (premise.isBlocked()) {
            if (activeOr.size() > 0) {
                return new RG3iRule_Right_Or_blocked(premise, mainFormula, activeOr.toArray(new Formula[activeOr.size()]));
            }
        } else {
            Collection<Formula> leftImplies = premise.getAllLeftFormulas(FormulaType.IMPLIES_WFF);
            LinkedList<Formula> activeImplies = new LinkedList<Formula>();
            LinkedList<Formula> leftImpliesToTreat = new LinkedList<Formula>();
            if (leftImplies != null) {
                for (Formula implication : leftImplies) {
                    Formula A = implication.immediateSubformulas()[0];
                    if (evaluator.eval(A) == EvaluationValue.F) continue;
                    activeImplies.add(A);
                    leftImpliesToTreat.add(implication);
                }
            }
            if (activeOr.size() > 0 || activeImplies.size() > 0) {
                RG3iRule_Succ succRule = this.buildIfApplicable(this.evaluation, premise, activeOr, activeImplies);
                if (activeImplies.size() == 0) {
                    if (succRule != null) {
                        return succRule;
                    }
                } else {
                    return new MetaBacktrackRule(premise, leftImpliesToTreat, succRule);
                }
            }
        }
        if (lastIteration.getMove() != IterationInfo.Move.CLASH_DETECTION_RULE_APPLICATION) {
            return new RG3iClashDetectionRule(this.evaluation, premise, this.FALSE);
        }
        return null;
    }

    private RG3iRule_Succ buildIfApplicable(_EvaluationFactory evaluation, _MarkedSingleSuccedentSequent premise, LinkedList<Formula> activeImplies, LinkedList<Formula> activeOr) {
        if (premise.isBlocked()) {
            return null;
        }
        if (activeOr.size() == 0 && activeImplies.size() == 0) {
            return null;
        }
        if (premise.isIdentityAxiom() || premise.containsLeft(this.FALSE)) {
            return null;
        }
        Formula rightFormula = premise.getRight();
        if (!this.checkRightFormula(premise, rightFormula)) {
            return null;
        }
        ArrayList<Formula> activeFormulas = new ArrayList<Formula>();
        if (activeOr != null) {
            activeFormulas.addAll(activeOr);
        }
        if (activeImplies != null) {
            activeFormulas.addAll(activeImplies);
        }
        return new RG3iRule_Succ(premise, activeFormulas);
    }

    private boolean checkRightFormula(_MarkedSingleSuccedentSequent premise, Formula rightFormula) {
        if (rightFormula.isAtomic()) {
            if (rightFormula.equals(this.FALSE)) {
                return true;
            }
            return !premise.containsLeft(rightFormula);
        }
        return rightFormula.mainConnective() == PropositionalConnective.OR;
    }

    public _EvaluationFactory getEvaluationFactory() {
        return this.evaluation;
    }
}

