/*
 * Decompiled with CFR 0.152.
 */
package ipl.rg3ied.tp;

import ipl.g3ied.sequents.G3iFormulaFactory;
import ipl.g3ied.sequents.MarkedSequentImplementations;
import ipl.rg3ied.tp.LatexCTreeFormatter;
import ipl.rg3ied.tp.Strategy;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine._Prover;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwb.tracesupport._LatexSupport;

public class RG3IEDProver
implements _Prover,
_LatexSupport {
    private static String RG3IED_DESCRIPTION = "RG3i - unprovability calculus for Intuitionistic Propositional Logic (dual of G3IED)";
    private static String RG3IED_NAME = "rg3ied";
    private static String RG3IED_VERSION = "1.0";
    public static final MarkedSequentImplementations DEFAULT_SEQ_IMPL = MarkedSequentImplementations.SEQ_ON_ARRAY;
    private G3iFormulaFactory formulaFactory = new G3iFormulaFactory();
    private Strategy strategy = new Strategy(this.formulaFactory);
    private ProverName proverName = new ProverName(RG3IED_NAME);
    private MarkedSequentImplementations sequentsImplementation;

    public RG3IEDProver() {
        this.proverName.setVersion(RG3IED_VERSION);
        this.proverName.setDescription(RG3IED_DESCRIPTION);
    }

    @Override
    public _Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ProverName getProverName() {
        return this.proverName;
    }

    public void configure(MarkedSequentImplementations impl) {
        this.sequentsImplementation = impl != null ? impl : DEFAULT_SEQ_IMPL;
        this.proverName.setVariant("seq=" + this.sequentsImplementation.getName());
    }

    @Override
    public ProvabilityStatus statusFor(ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                return ProvabilityStatus.UNPROVABLE;
            }
            case FAILURE: {
                return ProvabilityStatus.PROVABLE;
            }
        }
        return null;
    }

    @Override
    public _LatexCTreeFormatter getLatexProofFormatter() {
        return new LatexCTreeFormatter(this.strategy.getEvaluationFactory());
    }
}

