/*
 * Decompiled with CFR 0.152.
 */
package ipl.rg3ied.launcher;

import ipl.g3ied.sequents.MarkedSequentLatexFormatter;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import ipl.rg3ied.launcher.KripkeModel;
import java.io.PrintStream;
import java.util.LinkedList;
import jtabwbx.prop.formula.Formula;

class KripkeModelLatexGenerator {
    KripkeModel model;
    _MarkedSingleSuccedentSequent goal;
    private final String LATEX_PREAMBLE = "\\documentclass[10pt]{article}\n\\usepackage{tikz}\n\\usepackage{color}\n\\usepackage{xifthen}\n\\pdfpagewidth 200in\n\\pdfpageheight 100in\n\\DeclareMathSizes{10}{12}{12}{8}\n%% \\labseq{Theta}{Gamma}{Delta} writes the sequent Theta;Gamma ==> Delta\n\\newcommand{\\labseq}[3]{\n[\\ifthenelse{\\isempty{#2}}{}{#2}\\, \n\\stackrel{\\textrm{#1}}{\\Longrightarrow}\\, \n\\ifthenelse{\\isempty{#3}}{}{#3}\\, \n]}\n";
    private final String LATEX_BEGIN_DOCUMENT = "\\begin{document}\n\\thispagestyle{empty}\n";
    private final String LATEX_BEGIN_MODEL = "\\begin{tikzpicture}\n\\path[grow'=up,every node/.style={fill=gray!30,rounded corners},\nlevel 1/.style = {sibling distance = 40mm},\nlevel 2/.style = {sibling distance = 20mm},\n level 3/.style = {sibling distance = 10mm},\n edge from parent/.style={black,draw}]\n\n";
    private final String LATEX_END_MODEL = ";\n\\end{tikzpicture}\n";
    private final String LATEX_END_COCUMENT = "\\end{document}";
    private final String NODE_BEGIN = "node{";
    private final String NODE_END = "}\n";
    private final String CHILD_BEGIN = "child{\n";
    private final String CHILD_END = "}\n";
    private final String INDENTATION = " ";
    private static String[][] replacement = new String[][]{{"_", "\\\\_"}, {"\\$", "\\$"}};

    KripkeModelLatexGenerator(KripkeModel model, _MarkedSingleSuccedentSequent goal) {
        this.model = model;
        this.goal = goal;
    }

    public void generateLatex(PrintStream out) {
        out.print("\\documentclass[10pt]{article}\n\\usepackage{tikz}\n\\usepackage{color}\n\\usepackage{xifthen}\n\\pdfpagewidth 200in\n\\pdfpageheight 100in\n\\DeclareMathSizes{10}{12}{12}{8}\n%% \\labseq{Theta}{Gamma}{Delta} writes the sequent Theta;Gamma ==> Delta\n\\newcommand{\\labseq}[3]{\n[\\ifthenelse{\\isempty{#2}}{}{#2}\\, \n\\stackrel{\\textrm{#1}}{\\Longrightarrow}\\, \n\\ifthenelse{\\isempty{#3}}{}{#3}\\, \n]}\n");
        out.print("\\begin{document}\n\\thispagestyle{empty}\n");
        MarkedSequentLatexFormatter seqform = new MarkedSequentLatexFormatter();
        out.print("\\begin{minipage}{100in}\n");
        out.print("{\\Large {\\bf Countermodel for} $" + seqform.toLatex(this.goal) + "$}\n\\\\[4ex]\n\n");
        out.print("\\end{minipage}\n");
        out.print("\\begin{tikzpicture}\n\\path[grow'=up,every node/.style={fill=gray!30,rounded corners},\nlevel 1/.style = {sibling distance = 40mm},\nlevel 2/.style = {sibling distance = 20mm},\n level 3/.style = {sibling distance = 10mm},\n edge from parent/.style={black,draw}]\n\n");
        this._toLatex(out, "", this.model);
        out.print(";\n\\end{tikzpicture}\n");
        out.print("\\end{document}");
    }

    private void _toLatex(PrintStream out, String indentation, KripkeModel model) {
        out.print("node{");
        LinkedList<Formula> set = model.getForcedPropositions();
        if (set == null) {
            out.print(String.valueOf(model.getName()) + ": ");
        } else {
            Formula[] a = set.toArray(new Formula[set.size()]);
            out.print(String.valueOf(model.getName()) + ": " + KripkeModelLatexGenerator.toLatex(a));
        }
        out.print("}\n");
        LinkedList<KripkeModel> successors = model.getSuccessors();
        if (successors != null) {
            for (KripkeModel succ : successors) {
                out.print("child{\n");
                this._toLatex(out, String.valueOf(indentation) + " ", succ);
                out.print("}\n");
            }
        }
    }

    public static String toLatex(Formula[] a) {
        String str = "";
        if (a == null || a.length == 0) {
            return "";
        }
        int i = 0;
        while (i < a.length) {
            str = String.valueOf(str) + KripkeModelLatexGenerator.toLatex(a[i]) + (i < a.length - 1 ? ", " : "");
            ++i;
        }
        return str;
    }

    private static String toLatex(Formula wff) {
        String name = wff.format();
        if (name.equals("FALSE") || name.equals("false")) {
            return "$\\bot$";
        }
        if (name.equals("TRUE") || name.equals("true")) {
            return "$\\top$";
        }
        return KripkeModelLatexGenerator.correctName(name);
    }

    private static String correctName(String name) {
        String result = name;
        int i = 0;
        while (i < replacement.length) {
            result = result.replaceAll(replacement[i][0], replacement[i][1]);
            ++i;
        }
        return result;
    }
}

