/*
 * Decompiled with CFR 0.152.
 */
package ipl.rg3ied.calculus;

import ipl.g3ied.evaluation.EvaluationValue;
import ipl.g3ied.evaluation._EvaluationFactory;
import ipl.g3ied.evaluation._Evaluator;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import ipl.rg3ied.calculus.RG3IRuleIdentifiers;
import ipl.rg3ied.calculus._RG3IAbstractRule;
import java.util.Collection;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine._ClashDetectionRule;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.Formula;

public class RG3iClashDetectionRule
implements _ClashDetectionRule,
_RG3IAbstractRule {
    private _MarkedSingleSuccedentSequent premise;
    private final Formula FALSE;
    _Evaluator evaluator;

    public RG3iClashDetectionRule(_EvaluationFactory evaluation, _MarkedSingleSuccedentSequent premise, Formula FALSE) {
        this.premise = premise;
        this.FALSE = FALSE;
        this.evaluator = evaluation.buildEvaluationFunction(premise);
    }

    @Override
    public String name() {
        return RG3IRuleIdentifiers.CLASH_DETECTION.name();
    }

    @Override
    public _MarkedSingleSuccedentSequent goal() {
        return this.premise;
    }

    @Override
    public ProofSearchResult status() {
        Formula H;
        if (this.premise.isBlocked()) {
            return ProofSearchResult.FAILURE;
        }
        if (this.premise.getLeft(FormulaType.AND_WFF) != null || this.premise.getLeft(FormulaType.OR_WFF) != null) {
            return ProofSearchResult.FAILURE;
        }
        if (this.premise.containsLeft(this.FALSE)) {
            return ProofSearchResult.FAILURE;
        }
        Collection<Formula> leftImplications = this.premise.getAllLeftFormulas(FormulaType.IMPLIES_WFF);
        if (leftImplications != null) {
            for (Formula implication : leftImplications) {
                Formula A = implication.immediateSubformulas()[0];
                if (this.evaluator.eval(A) == EvaluationValue.F) continue;
                return ProofSearchResult.FAILURE;
            }
        }
        if ((H = this.premise.getRight()).equals(this.FALSE)) {
            return ProofSearchResult.SUCCESS;
        }
        if (H.isAtomic()) {
            if (this.premise.containsLeft(H)) {
                return ProofSearchResult.FAILURE;
            }
            return ProofSearchResult.SUCCESS;
        }
        if (H.mainConnective() == PropositionalConnective.OR) {
            Formula[] subformulas;
            Formula[] formulaArray = subformulas = H.immediateSubformulas();
            int n = subformulas.length;
            int n2 = 0;
            while (n2 < n) {
                Formula disjunct = formulaArray[n2];
                if (this.evaluator.eval(disjunct) != EvaluationValue.F) {
                    return ProofSearchResult.FAILURE;
                }
                ++n2;
            }
            return ProofSearchResult.SUCCESS;
        }
        return ProofSearchResult.FAILURE;
    }

    @Override
    public RG3IRuleIdentifiers getRuleIdentifier() {
        return RG3IRuleIdentifiers.CLASH_DETECTION;
    }
}

