/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.tp;

import ipl.g3ied.calculus.ED_Rule_Left_Implies;
import ipl.g3ied.calculus.ED_Rule_Right_Or;
import ipl.g3ied.evaluation._EvaluationFactory;
import ipl.g3ied.evaluation._Evaluator;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import jtabwb.engine.NoSuchBacktrackRuleException;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._RuleWithDetails;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;

public class StaticMetaBacktrackRule
implements _MetaBacktrackRule,
_RuleWithDetails {
    private final String NAME = "G3ied Meta Backtrack rule";
    private _MarkedSingleSuccedentSequent premise;
    private LinkedList<Formula> leftImplies;
    private Formula rightOr;
    private Formula[] activeDisjunts;
    private int totalNumberOfRules;
    private _Evaluator evaluator;
    boolean treatRightOr;
    private Iterator<Formula> iterator;
    static final String FMT_EVAL = "\nEval(%s, premise)=%s";
    static final String TITLE_EVAL_LEFT_IMPLIES = "\n== EVALUATION OF THE ANTECEDENT OF LEFT-IMPLIES";
    static final String TITLE_EVAL_RIGHT_OR = "\n== EVALUATION OF THE SUBFORMULAS OF RIGHT-OR";

    public StaticMetaBacktrackRule(_EvaluationFactory evaluation, _MarkedSingleSuccedentSequent premise, LinkedList<Formula> activeBacktrackFormulas, Formula rightOr, Formula[] activeDisjunts) {
        this.premise = premise;
        this.evaluator = evaluation.buildEvaluationFunction(premise);
        this.leftImplies = activeBacktrackFormulas;
        this.activeDisjunts = activeDisjunts;
        this.rightOr = rightOr;
        this.iterator = this.leftImplies == null ? null : this.leftImplies.iterator();
        this.treatRightOr = rightOr != null;
        this.totalNumberOfRules = (this.leftImplies == null ? 0 : this.leftImplies.size()) + (this.rightOr == null ? 0 : 1);
    }

    @Override
    public String name() {
        return "G3ied Meta Backtrack rule";
    }

    @Override
    public _MarkedSingleSuccedentSequent goal() {
        return this.premise;
    }

    @Override
    public _AbstractRule nextRule() throws NoSuchBacktrackRuleException {
        try {
            if (this.treatRightOr) {
                this.treatRightOr = false;
                return new ED_Rule_Right_Or(this.premise, this.rightOr, this.activeDisjunts);
            }
            return new ED_Rule_Left_Implies(this.premise, this.iterator.next());
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBacktrackRuleException();
        }
    }

    @Override
    public boolean hasNextRule() {
        return this.treatRightOr || this.iterator.hasNext();
    }

    @Override
    public int totalNumberOfRules() {
        return this.totalNumberOfRules;
    }

    @Override
    public String getDetails() {
        Formula disj;
        Collection<Formula> implications = this.premise.getAllLeftFormulas(FormulaType.IMPLIES_WFF);
        String str = "";
        if (implications != null) {
            str = TITLE_EVAL_LEFT_IMPLIES;
            for (Formula formula : implications) {
                Formula antecedent = formula.immediateSubformulas()[0];
                String valueOfEvaluation = this.evaluator.eval(antecedent).toString();
                str = String.valueOf(str) + String.format(FMT_EVAL, antecedent.toString(), valueOfEvaluation.toString());
            }
        }
        if ((disj = this.premise.getRightFormulaOfType(FormulaType.OR_WFF)) != null) {
            str = String.valueOf(str) + TITLE_EVAL_RIGHT_OR;
            Formula[] formulaArray = disj.immediateSubformulas();
            int n = formulaArray.length;
            int n2 = 0;
            while (n2 < n) {
                Formula w = formulaArray[n2];
                String valueOfEvaluation = this.evaluator.eval(w).toString();
                str = String.valueOf(str) + String.format(FMT_EVAL, w.toString(), valueOfEvaluation.toString());
                ++n2;
            }
        }
        return str;
    }
}

