/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.launcher;

import ferram.messages.MessageManager;
import ipl.g3ied.evaluation.AvailableEvaluations;
import ipl.g3ied.launcher.InitialNodeSetBuilder;
import ipl.g3ied.launcher.LocalMessageManager;
import ipl.g3ied.launcher.SelectableEvaluations;
import ipl.g3ied.launcher.SelectableSequentImplementations;
import ipl.g3ied.launcher.SelectableStrategies;
import ipl.g3ied.launcher.SingelExecutionConfigurator;
import ipl.g3ied.sequents.MarkedSequentImplementations;
import ipl.g3ied.tp.AvailableStrategies;
import ipl.g3ied.tp.G3IEDProver;
import jtabwb.launcher.Launcher;
import jtabwbx.problems.ILTPProblemReader;
import jtabwbx.problems.JTabWbSimpleProblemReader;
import jtabwbx.problems.PlainProblemReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Main {
    private final String OPTION_PROPERTIES_BUNDLE_NAME = String.valueOf(this.getClass().getPackage().getName()) + ".options";
    private static String FORMULA_SYNTAX_DESCRIPTION = "Syntax of formulas\n  atoms: Java identifiers\nlogical: false, & (and), | (or), ~ (not), -> (implies), <=> (iff)\n  notes: (~ A) is translated as (A -> false)\n         (A <=> B) is translated as ((A -> B) & (B -> A))";
    private static String WELCOME = "Launcher for G3ied and RG3ied - Evaluation driven calculi for IPL";
    static MarkedSequentImplementations DEFAULT_SEQ_IMPLEMENTATION = G3IEDProver.DEFAULT_SEQ_IMPL;
    static AvailableStrategies DEFAULT_STRATEGY = G3IEDProver.DEFAULT_VARIANT;
    static AvailableEvaluations DEFAULT_EVALUTAION = G3IEDProver.DEFAULT_EVALUATION;
    private final Class<G3IEDProver> G3I_CLASS = G3IEDProver.class;
    private final String G3I_NAME = "g3ied";
    private SelectableSequentImplementations availableSequentImplementations;
    private SelectableStrategies availableaVariants;
    private SelectableEvaluations selectableEvaluations;
    final Launcher launcher = new Launcher();
    private MarkedSequentImplementations selectedSequentsImplementation;
    private AvailableStrategies selectedStrategy;
    private AvailableEvaluations selectedEvaluation;

    private Main() {
        this.availableSequentImplementations = new SelectableSequentImplementations();
        this.availableSequentImplementations.setDefault(DEFAULT_SEQ_IMPLEMENTATION);
        this.availableaVariants = new SelectableStrategies();
        this.availableaVariants.setDefault(DEFAULT_STRATEGY);
        this.selectableEvaluations = new SelectableEvaluations();
        this.selectableEvaluations.setDefault(DEFAULT_EVALUTAION);
    }

    private Options buildCmdLineOptions() {
        MessageManager msg = new MessageManager(this.OPTION_PROPERTIES_BUNDLE_NAME);
        Options options = new Options();
        options.addOption(Option.builder((String)CmdLineOptionsNames.STRATEGY).hasArg(true).desc(msg.getMsg("STRATEGY.description", new Object[]{this.availableaVariants.getNames()})).build());
        options.addOption(Option.builder((String)CmdLineOptionsNames.EVALUATION).hasArg(true).desc(msg.getMsg("EVALUATION.description", new Object[]{this.selectableEvaluations.getNames()})).build());
        options.addOption(Option.builder((String)CmdLineOptionsNames.SEQUENTS_IMPLEMENTATIO).hasArg(true).argName("implementation").desc(msg.getMsg("SEQ.description", new Object[]{this.availableSequentImplementations.getNames()})).build());
        options.addOption(Option.builder().longOpt(CmdLineOptionsNames.LONG_NAME_LIST_SEQ_IMPLEMENTATIONS).hasArg(false).desc(msg.getMsg("LSEQ.description", new Object[]{DEFAULT_SEQ_IMPLEMENTATION.name()})).build());
        options.addOption(Option.builder().longOpt(CmdLineOptionsNames.LONG_NAME_LIST_STRATEGIES).hasArg(false).desc(msg.getMsg("LSTRATEGY.description")).build());
        options.addOption(Option.builder().longOpt(CmdLineOptionsNames.LONG_NAME_LIST_EVALUATIONS).hasArg(false).desc(msg.getMsg("LEVAL.description")).build());
        return options;
    }

    private void processCommandLineOptions(String[] args) {
        String varName;
        Launcher.LaunchConfiguration launcherConfiguration = this.launcher.processCmdLineArguments(args);
        CommandLine commandLine = launcherConfiguration.getCommandLine();
        if (commandLine.hasOption(CmdLineOptionsNames.LONG_NAME_LIST_SEQ_IMPLEMENTATIONS)) {
            LocalMessageManager.println("available.sequents.implementations", this.availableSequentImplementations.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.LONG_NAME_LIST_STRATEGIES)) {
            LocalMessageManager.println("available.strategies", this.availableaVariants.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.LONG_NAME_LIST_EVALUATIONS)) {
            LocalMessageManager.println("available.evaluations", this.selectableEvaluations.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.SEQUENTS_IMPLEMENTATIO)) {
            String optValue = commandLine.getOptionValue(CmdLineOptionsNames.SEQUENTS_IMPLEMENTATIO);
            MarkedSequentImplementations seqimpl = this.availableSequentImplementations.searchByName(optValue);
            if (seqimpl == null) {
                LocalMessageManager.println("option.no.value.with.name", optValue, CmdLineOptionsNames.SEQUENTS_IMPLEMENTATIO);
                System.exit(1);
            } else {
                this.selectedSequentsImplementation = seqimpl;
            }
        } else {
            this.selectedSequentsImplementation = DEFAULT_SEQ_IMPLEMENTATION;
        }
        if (commandLine.hasOption(CmdLineOptionsNames.STRATEGY)) {
            varName = commandLine.getOptionValue(CmdLineOptionsNames.STRATEGY);
            AvailableStrategies var = this.availableaVariants.searchByName(varName);
            if (var == null) {
                LocalMessageManager.println("available.variants.wrong", varName);
                System.exit(1);
            } else {
                this.selectedStrategy = var;
            }
        } else {
            this.selectedStrategy = DEFAULT_STRATEGY;
        }
        if (commandLine.hasOption(CmdLineOptionsNames.EVALUATION)) {
            varName = commandLine.getOptionValue(CmdLineOptionsNames.EVALUATION);
            AvailableEvaluations eval = this.selectableEvaluations.searchByName(varName);
            if (eval == null) {
                LocalMessageManager.println("available.evaluation.wrong", varName);
                System.exit(1);
            } else {
                this.selectedEvaluation = eval;
            }
        } else {
            this.selectedEvaluation = DEFAULT_EVALUTAION;
        }
    }

    private void start(String[] args) {
        this.launcher.configLauncherName(this.getClass().getCanonicalName());
        this.launcher.optConfigWelcomeMessage(WELCOME);
        this.launcher.configStandardInputReader(new PlainProblemReader());
        this.launcher.optConfigInputSyntax(FORMULA_SYNTAX_DESCRIPTION);
        this.launcher.optConfigCmdLineOptions(this.buildCmdLineOptions());
        this.launcher.configProblemDescriptionReader("iltp", ILTPProblemReader.class);
        this.launcher.configProblemDescriptionReader("plain", PlainProblemReader.class);
        this.launcher.configProblemDescriptionReader("jtw", JTabWbSimpleProblemReader.class, true);
        this.launcher.configTheoremProver("g3ied", this.G3I_CLASS, true);
        InitialNodeSetBuilder initialNodeSetBuilder = new InitialNodeSetBuilder();
        this.launcher.configInitialNodeSetBuilder(initialNodeSetBuilder);
        this.processCommandLineOptions(args);
        SingelExecutionConfigurator configurator = new SingelExecutionConfigurator(this.selectedStrategy, initialNodeSetBuilder, this.selectedSequentsImplementation, this.selectedEvaluation);
        this.launcher.optConfigSingleExecutionConfigurator(configurator);
        this.launcher.launch();
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.start(args);
    }

    private static class CmdLineOptionsNames {
        static String SEQUENTS_IMPLEMENTATIO = "seq";
        static String STRATEGY = "st";
        static String EVALUATION = "ev";
        static String LONG_NAME_LIST_SEQ_IMPLEMENTATIONS = "list-seq";
        static String LONG_NAME_LIST_STRATEGIES = "list-strategies";
        static String LONG_NAME_LIST_EVALUATIONS = "list-evaluations";

        private CmdLineOptionsNames() {
        }
    }
}

