/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.launcher;

import ipl.g3ied.sequents.G3iFormulaFactory;
import ipl.g3ied.sequents.MSequentOnArrays;
import ipl.g3ied.sequents.MSequentOnBSF;
import ipl.g3ied.sequents.MSequentOnBitSet;
import ipl.g3ied.sequents.MSequentOnLists;
import ipl.g3ied.sequents.MarkedSequentImplementations;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import java.util.LinkedList;
import jtabwb.launcher.InitialGoalBuilderException;
import jtabwb.launcher.ProblemDescription;
import jtabwb.launcher._InitialGoalBuilder;
import jtabwb.util.ImplementationError;
import jtabwbx.problems.ILTPProblem;
import jtabwbx.problems.JTabWbSimpleProblem;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.parser.FormulaParseException;
import jtabwbx.prop.parser.PropositionalFormulaParser;

public class InitialNodeSetBuilder
implements _InitialGoalBuilder {
    private MarkedSequentImplementations selectedImplementation;
    private G3iFormulaFactory formulaFactory;

    public void setSequentImplementation(MarkedSequentImplementations selectedImplementation) {
        this.selectedImplementation = selectedImplementation;
    }

    public void setFormulaFactory(G3iFormulaFactory factory) {
        this.formulaFactory = factory;
    }

    @Override
    public _MarkedSingleSuccedentSequent buildInitialNodeSet(ProblemDescription inputProblem) throws InitialGoalBuilderException {
        if (inputProblem instanceof JTabWbSimpleProblem) {
            return this.buildFrom((JTabWbSimpleProblem)inputProblem);
        }
        if (inputProblem instanceof ILTPProblem) {
            return this.buildFrom((ILTPProblem)inputProblem);
        }
        throw new ImplementationError("Unkonw problem description.");
    }

    private _MarkedSingleSuccedentSequent getEmptyNodeSet(MarkedSequentImplementations impl, G3iFormulaFactory formulaFactory) {
        switch (impl) {
            case SEQ_ON_ARRAY: {
                return new MSequentOnArrays(formulaFactory);
            }
            case SEQ_ON_LIST: {
                return new MSequentOnLists();
            }
            case SEQ_ON_BITSET: {
                return new MSequentOnBitSet(formulaFactory);
            }
            case SEQ_ON_BSF: {
                MSequentOnBSF nodeSet = new MSequentOnBSF(formulaFactory);
                return nodeSet;
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }

    private _MarkedSingleSuccedentSequent buildFrom(JTabWbSimpleProblem inputProblem) throws InitialGoalBuilderException {
        PropositionalFormulaParser parser = new PropositionalFormulaParser();
        String conjecture = inputProblem.getConjecture();
        if (conjecture == null) {
            throw new InitialGoalBuilderException("No problem formula defined in the input problem.");
        }
        Formula wff = null;
        try {
            wff = this.formulaFactory.buildFrom(parser.parse(conjecture));
        }
        catch (FormulaParseException e) {
            throw new InitialGoalBuilderException(e.getMessage());
        }
        _MarkedSingleSuccedentSequent nodeSet = this.getEmptyNodeSet(this.selectedImplementation, this.formulaFactory);
        nodeSet.addRight(wff);
        return nodeSet;
    }

    private _MarkedSingleSuccedentSequent buildFrom(ILTPProblem inputProblem) throws InitialGoalBuilderException {
        PropositionalFormulaParser parser = new PropositionalFormulaParser();
        String conjecture = inputProblem.getConjecture();
        if (conjecture == null) {
            throw new InitialGoalBuilderException("No problem formula defined in the input problem.");
        }
        Formula right = null;
        LinkedList<Formula> left = null;
        try {
            right = this.formulaFactory.buildFrom(parser.parse(conjecture));
            if (inputProblem.getAxioms() != null) {
                left = new LinkedList<Formula>();
                for (String axiom : inputProblem.getAxioms()) {
                    left.add(this.formulaFactory.buildFrom(parser.parse(axiom)));
                }
            }
        }
        catch (FormulaParseException e) {
            throw new InitialGoalBuilderException(e.getMessage());
        }
        _MarkedSingleSuccedentSequent nodeSet = this.getEmptyNodeSet(this.selectedImplementation, this.formulaFactory);
        nodeSet.addRight(right);
        if (left != null) {
            for (Formula axiom : left) {
                nodeSet.addLeft(axiom);
            }
        }
        return nodeSet;
    }
}

