/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;

public class SetTrieOfFormulas {
    private SetTrieNode root = new SetTrieNode(null);

    public void insert(BitSetOfFormulas set) {
        this.insert(this.root, set.cursor());
    }

    private void insert(SetTrieNode node, BitSetOfFormulas.Cursor cursor) {
        block6: {
            if (cursor.existsCurrentElement()) {
                if (node.firstChild == null) {
                    node.firstChild = new SetTrieNode(cursor.currentFormula());
                    cursor.moveToNext();
                    this.insert(node.firstChild, cursor);
                } else {
                    SetTrieNode pt = node.firstChild;
                    while (pt.value.getIndex() != cursor.currentFormula().getIndex()) {
                        if (pt.firstSibling != null) {
                            pt = pt.firstSibling;
                            continue;
                        }
                        pt.firstSibling = new SetTrieNode(cursor.currentFormula());
                        cursor.moveToNext();
                        this.insert(pt.firstSibling, cursor);
                        break block6;
                    }
                    cursor.moveToNext();
                    this.insert(pt, cursor);
                }
            } else {
                node.lastElement = true;
            }
        }
    }

    public boolean contains(BitSetOfFormulas set) {
        return this.search(this.root, set.cursor());
    }

    private boolean search(SetTrieNode node, BitSetOfFormulas.Cursor cursor) {
        if (cursor.existsCurrentElement()) {
            if (node.firstChild != null) {
                SetTrieNode pt = node.firstChild;
                while (pt.value.getIndex() != cursor.currentFormula().getIndex()) {
                    if (pt.firstSibling != null) {
                        pt = pt.firstSibling;
                        continue;
                    }
                    return false;
                }
                cursor.moveToNext();
                boolean result = this.search(pt, cursor);
                return result;
            }
            return false;
        }
        return node.lastElement;
    }

    public boolean containsSubsetOf(BitSetOfFormulas set) {
        return this.existsSubsetOf(this.root, set.cursor());
    }

    private boolean existsSubsetOf(SetTrieNode node, BitSetOfFormulas.Cursor cursor) {
        if (node.lastElement) {
            return true;
        }
        if (!cursor.existsCurrentElement()) {
            return false;
        }
        boolean found = false;
        SetTrieNode pt = node.firstChild;
        while (pt != null) {
            if (pt.value.getIndex() == cursor.currentFormula().getIndex()) {
                cursor.moveToNext();
                found = this.existsSubsetOf(pt, cursor);
                break;
            }
            pt = pt.firstSibling;
        }
        if (!found) {
            cursor.moveToNext();
            return this.existsSubsetOf(node, cursor);
        }
        return true;
    }

    public boolean containsSupersetOf(BitSetOfFormulas set) {
        boolean result = this.existsSupersetOf(this.root, set.cursor());
        return result;
    }

    public boolean existsSupersetOf(SetTrieNode node, BitSetOfFormulas.Cursor cursor) {
        if (!cursor.existsCurrentElement()) {
            return true;
        }
        if (node == null) {
            return false;
        }
        if (node.value == null) {
            if (node.firstChild != null) {
                return this.existsSupersetOf(node.firstChild, cursor);
            }
            return false;
        }
        boolean found = false;
        SetTrieNode pt = node;
        int from = cursor.currentFormula().getIndex();
        while (pt != null && !found) {
            if (pt.value.getIndex() <= from) {
                if (pt.value.getIndex() == from) {
                    BitSetOfFormulas.Cursor cloned = cursor.clone();
                    cloned.moveToNext();
                    found = this.existsSupersetOf(pt.firstChild, cloned);
                } else {
                    found = this.existsSupersetOf(pt.firstChild, cursor);
                }
            }
            pt = pt.firstSibling;
        }
        return found;
    }

    private static class SetTrieNode {
        Formula value;
        SetTrieNode firstChild;
        SetTrieNode firstSibling;
        boolean lastElement;

        public SetTrieNode(Formula value) {
            this.value = value;
            this.firstSibling = null;
            this.firstChild = null;
            this.lastElement = false;
        }
    }
}

