/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula._FormulaSet;

public class BitSetOfFormulas
extends BitSet
implements _FormulaSet,
Iterable<Formula> {
    FormulaFactory formulaFactory;

    public BitSetOfFormulas(FormulaFactory factory) {
        super(factory.numberOfGeneratedFormulas());
        this.formulaFactory = factory;
    }

    @Override
    public boolean add(Formula wff) {
        int idx = wff.getIndex();
        if (this.get(idx)) {
            return true;
        }
        this.set(idx);
        return false;
    }

    @Override
    public void addAll(_FormulaSet set) {
        for (Formula wff : set) {
            this.add(wff);
        }
    }

    public void addAll(BitSetOfFormulas set) {
        this.or(set);
    }

    public void and(BitSetOfFormulas set) {
        super.and(set);
    }

    @Override
    public BitSetOfFormulas clone() {
        BitSetOfFormulas newset = (BitSetOfFormulas)super.clone();
        newset.formulaFactory = this.formulaFactory;
        return newset;
    }

    @Override
    public boolean contains(Formula wff) {
        return this.get(wff.getIndex());
    }

    public boolean containsFormulaOfType(FormulaType type) {
        return this.getFirst(type) != null;
    }

    @Override
    public Collection<Formula> getAllFormulas() {
        LinkedList<Formula> list = new LinkedList<Formula>();
        int i = this.nextSetBit(0);
        while (i >= 0) {
            list.add(this.formulaFactory.getByIndex(i));
            i = this.nextSetBit(i + 1);
        }
        return list.size() == 0 ? null : list;
    }

    public Collection<Formula> getAllFormulas(FormulaType formulaType) {
        LinkedList<Formula> list = new LinkedList<Formula>();
        int i = this.nextSetBit(0);
        while (i >= 0) {
            Formula wff = this.formulaFactory.getByIndex(i);
            if (wff.getFormulaType() == formulaType) {
                list.add(wff);
            }
            i = this.nextSetBit(i + 1);
        }
        return list.size() == 0 ? null : list;
    }

    public BitSetOfFormulas getBitsetOfAllFormulas(FormulaType formulaType) {
        BitSetOfFormulas bset = new BitSetOfFormulas(this.formulaFactory);
        int i = this.nextSetBit(0);
        while (i >= 0) {
            Formula wff = this.formulaFactory.getByIndex(i);
            if (wff.getFormulaType() == formulaType) {
                bset.add(wff);
            }
            i = this.nextSetBit(i + 1);
        }
        return bset.isEmpty() ? null : bset;
    }

    @Override
    public Formula getFirst() {
        int firstIdx = this.nextSetBit(0);
        return firstIdx == -1 ? null : this.formulaFactory.getByIndex(firstIdx);
    }

    public Formula getFirstAndRemove() {
        int firstIdx = this.nextSetBit(0);
        if (firstIdx == -1) {
            return null;
        }
        Formula wff = this.formulaFactory.getByIndex(firstIdx);
        this.clear(wff.getIndex());
        return wff;
    }

    public Formula getFirstAndRemove(FormulaType type) {
        int i = this.nextSetBit(0);
        while (i >= 0) {
            Formula wff = this.formulaFactory.getByIndex(i);
            if (wff.getFormulaType() == type) {
                Formula found = this.formulaFactory.getByIndex(i);
                this.clear(found.getIndex());
                return found;
            }
            i = this.nextSetBit(i + 1);
        }
        return null;
    }

    public Formula getFirst(FormulaType type) {
        int i = this.nextSetBit(0);
        while (i >= 0) {
            Formula wff = this.formulaFactory.getByIndex(i);
            if (wff.getFormulaType() == type) {
                return this.formulaFactory.getByIndex(i);
            }
            i = this.nextSetBit(i + 1);
        }
        return null;
    }

    public Cursor cursor() {
        return new Cursor(this);
    }

    public FormulaFactory getFactory() {
        return this.formulaFactory;
    }

    @Override
    public Iterator<Formula> iterator() {
        return new Iterator<Formula>(){
            int nextElement;
            {
                this.nextElement = BitSetOfFormulas.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.nextElement >= 0;
            }

            @Override
            public Formula next() {
                Formula wff = BitSetOfFormulas.this.formulaFactory.getByIndex(this.nextElement);
                this.nextElement = BitSetOfFormulas.this.nextSetBit(this.nextElement + 1);
                return wff;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported.");
            }
        };
    }

    @Override
    public boolean remove(Formula wff) {
        boolean result = this.get(wff.getIndex());
        this.flip(wff.getIndex());
        return result;
    }

    @Override
    public Formula[] toArray() {
        Formula[] result = new Formula[this.cardinality()];
        int i = this.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            result[j] = this.formulaFactory.getByIndex(i);
            i = this.nextSetBit(i + 1);
            ++j;
        }
        return result;
    }

    public boolean subseteq(BitSetOfFormulas other) {
        BitSetOfFormulas cloned = this.clone();
        cloned.and(other);
        return cloned.equals(this);
    }

    public boolean superseteq(BitSetOfFormulas other) {
        return other.subseteq(this);
    }

    @Override
    public String toString() {
        Collection<Formula> all = this.getAllFormulas();
        if (all != null) {
            Formula[] array = all.toArray(new Formula[all.size()]);
            String str = "";
            int i = 0;
            while (i < array.length) {
                str = String.valueOf(str) + array[i].toString() + (i < array.length - 1 ? ", " : "");
                ++i;
            }
            return str;
        }
        return "";
    }

    public static class Cursor {
        private BitSetOfFormulas bitset;
        private int currentElement;
        private int nextElement;

        Cursor(BitSetOfFormulas bitset) {
            this.bitset = bitset;
            this.currentElement = bitset.nextSetBit(0);
            this.nextElement = this.currentElement >= 0 ? bitset.nextSetBit(this.currentElement + 1) : -1;
        }

        public boolean moveToFirst() {
            this.currentElement = this.bitset.nextSetBit(0);
            this.nextElement = this.currentElement >= 0 ? this.bitset.nextSetBit(this.currentElement + 1) : -1;
            return this.currentElement >= 0;
        }

        public boolean existsCurrentElement() {
            return this.currentElement >= 0;
        }

        public boolean existsNextElement() {
            return this.nextElement >= 0;
        }

        public Formula nextFormula() {
            if (this.nextElement >= 0) {
                return this.bitset.formulaFactory.getByIndex(this.nextElement);
            }
            throw new RuntimeException("Accessing an undefined position.");
        }

        public Formula currentFormula() {
            if (this.currentElement >= 0) {
                return this.bitset.formulaFactory.getByIndex(this.currentElement);
            }
            throw new RuntimeException("Accessing an undefined position.");
        }

        public boolean moveToNext() {
            if (this.currentElement >= 0) {
                this.currentElement = this.bitset.nextSetBit(this.currentElement + 1);
            }
            this.nextElement = this.currentElement >= 0 ? this.bitset.nextSetBit(this.currentElement + 1) : -1;
            return this.currentElement >= 0;
        }

        protected Cursor clone() {
            Cursor newCursor = new Cursor(this.bitset);
            newCursor.currentElement = this.currentElement;
            newCursor.nextElement = this.nextElement;
            return newCursor;
        }
    }
}

