/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import java.util.HashMap;
import java.util.LinkedList;
import jtabwb.engine.TraceNode;
import jtabwb.tracesupport.CTreeNode;
import jtabwb.tracesupport.ImplementationError;
import jtabwb.tracesupport.SequenceOfCtreeNodes;

public class ChildrenWithCtreeNodes {
    private TraceNode[] children;
    private HashMap<TraceNode, SequenceOfCtreeNodes> ctreesOfChild;
    private HashMap<TraceNode, SequenceOfCtreeNodes> succesfulCtreesOfChild;
    private HashMap<TraceNode, SequenceOfCtreeNodes> failedCtreesOfChild;

    public ChildrenWithCtreeNodes(LinkedList<TraceNode> children) {
        this.children = children.toArray(new TraceNode[children.size()]);
        this.ctreesOfChild = new HashMap();
        this.failedCtreesOfChild = new HashMap();
        this.succesfulCtreesOfChild = new HashMap();
    }

    public void put(TraceNode tnode, SequenceOfCtreeNodes ctrees) {
        this.ctreesOfChild.put(tnode, ctrees);
        for (CTreeNode node : ctrees) {
            switch (node.getStatus()) {
                case FAILURE: {
                    this.putFailed(tnode, node);
                    break;
                }
                case SUCCESS: {
                    this.putSuccessful(tnode, node);
                    break;
                }
                default: {
                    throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
                }
            }
        }
    }

    private void putSuccessful(TraceNode tnode, CTreeNode node) {
        SequenceOfCtreeNodes seq = this.succesfulCtreesOfChild.get(tnode);
        if (seq == null) {
            seq = new SequenceOfCtreeNodes();
            this.succesfulCtreesOfChild.put(tnode, seq);
        }
        seq.add(node);
    }

    private void putFailed(TraceNode tnode, CTreeNode node) {
        SequenceOfCtreeNodes seq = this.failedCtreesOfChild.get(tnode);
        if (seq == null) {
            seq = new SequenceOfCtreeNodes();
            this.failedCtreesOfChild.put(tnode, seq);
        }
        seq.add(node);
    }

    public SequenceOfCtreeNodes succesfulCTreesOfChild(int i) {
        return this.succesfulCtreesOfChild.get(this.children[i]);
    }

    public SequenceOfCtreeNodes failedCTreesOfChild(int i) {
        return this.failedCtreesOfChild.get(this.children[i]);
    }

    public int numberOfChildren() {
        return this.children.length;
    }
}

