/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.ForceBranchFailure;
import jtabwb.engine.ForceBranchSuccess;
import jtabwb.engine.ImplementationError;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._ClashDetectionRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._RegularRule;

public enum RuleType {
    BRANCH_EXISTS,
    CLASH_DETECTION_RULE,
    META_BACKTRACK_RULE,
    REGULAR,
    FORCE_BRANCH_FAILURE,
    FORCE_BRANCH_SUCCESS;


    public static RuleType getType(_AbstractRule ruleToApply) {
        if (ruleToApply instanceof ForceBranchFailure) {
            return FORCE_BRANCH_FAILURE;
        }
        if (ruleToApply instanceof ForceBranchSuccess) {
            return FORCE_BRANCH_SUCCESS;
        }
        if (ruleToApply instanceof _ClashDetectionRule) {
            return CLASH_DETECTION_RULE;
        }
        if (ruleToApply instanceof _BranchExistsRule) {
            return BRANCH_EXISTS;
        }
        if (ruleToApply instanceof _MetaBacktrackRule) {
            return META_BACKTRACK_RULE;
        }
        if (ruleToApply instanceof _RegularRule) {
            return REGULAR;
        }
        throw new ImplementationError("IMPLEMENTATION ERROR -- the rule should be an instance of a proper subtype of _AbstractRule but it is: " + ruleToApply.getClass().getCanonicalName());
    }
}

