/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.EnginePlain;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine._AbstractRule;

public class IterationInfo {
    long number_of_iterations;
    long number_of_generated_nodes;
    Move move = null;
    _AbstractRule applied_rule;
    ProofSearchResult current_node_set_status;
    int number_of_conclusions;
    int treated_conclusion;
    boolean backtrack_point_added;
    boolean branch_point_added;
    long number_of_restored_backtrack_points;
    long number_of_restored_branch_points;
    int max_stack_size;
    EnginePlain engine;

    IterationInfo(EnginePlain engine) {
        this.reset();
        this.engine = engine;
    }

    void reset() {
        this.number_of_iterations = 0L;
        this.number_of_generated_nodes = 0L;
        this.number_of_restored_backtrack_points = 0L;
        this.number_of_restored_branch_points = 0L;
        this.max_stack_size = 0;
        this.move = Move.INITIAL_STATE;
        this.current_node_set_status = null;
        this.applied_rule = null;
        this.number_of_conclusions = 0;
        this.treated_conclusion = -1;
        this.backtrack_point_added = false;
        this.branch_point_added = false;
    }

    public long getNumberOfIterations() {
        return this.number_of_iterations;
    }

    public _AbstractRule getAppliedRule() {
        return this.applied_rule;
    }

    public Move getMove() {
        return this.move;
    }

    public boolean backtrackPointAdded() {
        return this.backtrack_point_added;
    }

    public boolean branchPointAdded() {
        return this.branch_point_added;
    }

    public int getNumberOfConclusions() {
        return this.number_of_conclusions;
    }

    public int getTreatedConclusion() {
        return this.treated_conclusion;
    }

    public long getNumberOfGeneratedNodes() {
        return this.number_of_generated_nodes;
    }

    public long getNumberOfRestoredBacktrackPoints() {
        return this.number_of_restored_backtrack_points;
    }

    public long getNumberOfRestoredBranchPoints() {
        return this.number_of_restored_branch_points;
    }

    public int getMaxStackSize() {
        return this.max_stack_size;
    }

    public String getStackTrace() {
        return this.engine.getStackTrace();
    }

    public static enum Move {
        INITIAL_STATE,
        REGULAR_RULE_APPLICATION,
        BRANCH_EXISTS_RULE_APPLICATION,
        AND_BRANCH_POINT_SEARCH,
        BACKTRACK_POINT_SEARCH,
        CLASH_DETECTION_RULE_APPLICATION,
        FORCE_BRANCH_FAILURE_APPLICATION,
        FORCE_BRANCH_SUCCESS_APPLICATION,
        META_RULE_APPLICATION;

    }
}

