/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp.strategy.go_naive;

import ipl.nbu.calculus.ID_ClashDetectionRule;
import ipl.nbu.calculus.Up_Coercion;
import ipl.nbu.calculus.Up_Elim_False;
import ipl.nbu.calculus.Up_Elim_OR;
import ipl.nbu.calculus.Up_Intro_AND;
import ipl.nbu.calculus.Up_Intro_IMPLIES_1;
import ipl.nbu.calculus.Up_Intro_IMPLIES_2;
import ipl.nbu.calculus.Up_Intro_OR;
import ipl.nbu.evaluations.NbuEvaluationValue;
import ipl.nbu.evaluations._NbuEvaluationFactory;
import ipl.nbu.evaluations._NbuEvaluator;
import ipl.nbu.sequent.NbuSequentSupport;
import ipl.nbu.sequent._NbuSequent;
import ipl.nbu.tp.strategy.commons.GenericMetaBacktrackRule;
import ipl.nbu.tp.strategy.commons.HistoryFailure;
import ipl.nbu.tp.strategy.go_naive.DownMetaBacktrackRule;
import ipl.nbu.tp.strategy.go_naive.ImplementationError;
import java.util.LinkedList;
import jtabwb.engine.IterationInfo;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._Strategy;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaProposition;

public class StrategyGONaive
implements _Strategy {
    _NbuEvaluationFactory evaluationFactory;
    boolean verbose = false;

    public StrategyGONaive(_NbuEvaluationFactory evaluationFactory) {
        this.evaluationFactory = evaluationFactory;
    }

    @Override
    public _AbstractRule nextRule(_AbstractGoal currentGoal, IterationInfo lastIteration) {
        _NbuSequent premise = (_NbuSequent)currentGoal;
        if (premise.isUp()) {
            Formula rightFormula = premise.getRight();
            if (rightFormula.isAtomic()) {
                FormulaProposition wff = (FormulaProposition)rightFormula;
                if (premise.inHistory(wff)) {
                    return new HistoryFailure(premise);
                }
                BitSetOfFormulas elegible = null;
                if (premise.isUpUnBlocked()) {
                    elegible = NbuSequentSupport.elegibleOrFormulasInLeftHandSide(premise, this.evaluationFactory.buildEvaluationFunction(premise));
                }
                if (rightFormula.isFalse() && elegible == null) {
                    return new Up_Elim_False(premise);
                }
                LinkedList<_AbstractRule> addedRules = new LinkedList<_AbstractRule>();
                if (!rightFormula.isFalse()) {
                    addedRules.add(new Up_Coercion(premise));
                }
                addedRules.add(new Up_Elim_False(premise));
                if (elegible != null) {
                    for (Formula eleg : elegible.getAllFormulas()) {
                        addedRules.addLast(new Up_Elim_OR(premise, eleg));
                    }
                }
                return new GenericMetaBacktrackRule("ON_ATOMIC_BACKTRACK_RULE", premise, addedRules);
            }
            switch (rightFormula.mainConnective()) {
                case AND: {
                    return new Up_Intro_AND(premise, rightFormula);
                }
                case IMPLIES: {
                    _NbuEvaluator evaluator = this.evaluationFactory.buildEvaluationFunction(premise);
                    if (evaluator.eval(rightFormula.immediateSubformulas()[0]) == NbuEvaluationValue.T) {
                        return new Up_Intro_IMPLIES_1(premise, rightFormula);
                    }
                    return new Up_Intro_IMPLIES_2(premise, rightFormula);
                }
                case OR: {
                    BitSetOfFormulas elegible;
                    Up_Intro_OR introOr = new Up_Intro_OR(premise, rightFormula);
                    if (premise.isUpUnBlocked() && (elegible = NbuSequentSupport.elegibleOrFormulasInLeftHandSide(premise, this.evaluationFactory.buildEvaluationFunction(premise))) != null) {
                        LinkedList<_AbstractRule> rulesToApply = new LinkedList<_AbstractRule>();
                        rulesToApply.add(introOr);
                        for (Formula wff : elegible.getAllFormulas()) {
                            rulesToApply.addLast(new Up_Elim_OR(premise, wff));
                        }
                        return new GenericMetaBacktrackRule("Or-Intro and OR-Eliminations Meta Backtrack rule", premise, rulesToApply);
                    }
                    return introOr;
                }
            }
            throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
        }
        Formula toProve = premise.getRight();
        _AbstractRule lastApplied = lastIteration.getAppliedRule();
        if (!(lastApplied instanceof ID_ClashDetectionRule)) {
            return new ID_ClashDetectionRule(premise);
        }
        BitSetOfFormulas elegibleImplies = NbuSequentSupport.elegibleIMPLIESFormulasFor(premise, toProve);
        BitSetOfFormulas elegibleAnd = NbuSequentSupport.elegibleANDFormulasFor(premise, toProve);
        if (elegibleImplies != null || elegibleAnd != null) {
            return new DownMetaBacktrackRule(premise, toProve, elegibleAnd, elegibleImplies);
        }
        return null;
    }
}

