/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp.strategy.go_naive;

import ipl.nbu.calculus.Down_AbstractRegularRule;
import ipl.nbu.calculus.Down_Elim_AND;
import ipl.nbu.calculus.Down_Elim_IMPLIES;
import ipl.nbu.sequent._NbuSequent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import jtabwb.engine.NoSuchBacktrackRuleException;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._RuleWithDetails;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;

class DownMetaBacktrackRule
implements _MetaBacktrackRule,
_RuleWithDetails {
    private final String NAME = "Down Meta Backtrack rule";
    private Iterator<_AbstractRule> rules;
    private int totalNumberOfRules;
    private _NbuSequent premise;
    private BitSetOfFormulas elegibleImplies;
    private BitSetOfFormulas elegibleAnd;

    public DownMetaBacktrackRule(_NbuSequent premise, Formula toProve, BitSetOfFormulas elegibleAnd, BitSetOfFormulas elegibleImplies) {
        this.premise = premise;
        this.elegibleAnd = elegibleAnd;
        this.elegibleImplies = elegibleImplies;
        LinkedList<Down_AbstractRegularRule> rulesToApply = new LinkedList<Down_AbstractRegularRule>();
        if (elegibleAnd != null) {
            for (Formula conjunction : elegibleAnd.getAllFormulas()) {
                rulesToApply.addLast(new Down_Elim_AND(premise, toProve, conjunction));
            }
        }
        if (elegibleImplies != null) {
            for (Formula implication : elegibleImplies.getAllFormulas()) {
                rulesToApply.addLast(new Down_Elim_IMPLIES(premise, toProve, implication));
            }
        }
        this.rules = rulesToApply.iterator();
        this.totalNumberOfRules = rulesToApply.size();
    }

    @Override
    public String name() {
        return "Down Meta Backtrack rule";
    }

    @Override
    public _AbstractRule nextRule() throws NoSuchBacktrackRuleException {
        try {
            return this.rules.next();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBacktrackRuleException();
        }
    }

    @Override
    public boolean hasNextRule() {
        return this.rules.hasNext();
    }

    @Override
    public int totalNumberOfRules() {
        return this.totalNumberOfRules;
    }

    @Override
    public _AbstractGoal goal() {
        return this.premise;
    }

    @Override
    public String getDetails() {
        int i;
        Formula[] a;
        String str = "";
        if (this.elegibleImplies != null) {
            str = String.valueOf(str) + "\nElegible implies: ";
            a = this.elegibleImplies.getAllFormulas().toArray(new Formula[0]);
            i = 0;
            while (i < a.length) {
                str = String.valueOf(str) + a[i].format() + (i < a.length - 1 ? ", " : "");
                ++i;
            }
        }
        if (this.elegibleAnd != null) {
            str = String.valueOf(str) + "\nElegible and: ";
            a = this.elegibleAnd.getAllFormulas().toArray(new Formula[0]);
            i = 0;
            while (i < a.length) {
                str = String.valueOf(str) + a[i].format() + (i < a.length - 1 ? ", " : "");
                ++i;
            }
        }
        return str;
    }
}

