/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp.strategy.down;

import ipl.nbu.calculus.Up_Coercion;
import ipl.nbu.calculus.Up_Elim_False;
import ipl.nbu.calculus.Up_Elim_OR;
import ipl.nbu.calculus.Up_Intro_AND;
import ipl.nbu.calculus.Up_Intro_IMPLIES_1;
import ipl.nbu.calculus.Up_Intro_IMPLIES_2;
import ipl.nbu.calculus.Up_Intro_OR;
import ipl.nbu.evaluations.NbuEvaluationValue;
import ipl.nbu.evaluations._NbuEvaluationFactory;
import ipl.nbu.evaluations._NbuEvaluator;
import ipl.nbu.sequent.NbuFormulaFactory;
import ipl.nbu.sequent.NbuSequentSupport;
import ipl.nbu.sequent._NbuSequent;
import ipl.nbu.tp.NbuProver;
import ipl.nbu.tp.strategy.commons.GenericMetaBacktrackRule;
import ipl.nbu.tp.strategy.commons.HistoryFailure;
import ipl.nbu.tp.strategy.commons.PlainGlobalCache;
import ipl.nbu.tp.strategy.commons.RuleGlobalCacheSuccess;
import ipl.nbu.tp.strategy.commons._GlobalCache;
import ipl.nbu.tp.strategy.down.DownSearchSuccess;
import ipl.nbu.tp.strategy.down.ImplementationError;
import java.util.Collection;
import java.util.LinkedList;
import jtabwb.engine.Engine;
import jtabwb.engine.IterationInfo;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._Strategy;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaProposition;

public class StrategyDownExpansion
implements _Strategy {
    private _GlobalCache alreadyKnown;
    _NbuEvaluationFactory evaluationFactory;
    NbuFormulaFactory factory;
    boolean verbose = false;

    public StrategyDownExpansion(NbuFormulaFactory factory, _NbuEvaluationFactory evaluationFacotry) {
        this.evaluationFactory = evaluationFacotry;
        this.factory = factory;
        this.alreadyKnown = new PlainGlobalCache();
    }

    public StrategyDownExpansion(NbuFormulaFactory factory, _NbuEvaluationFactory evaluationFacotry, _GlobalCache globalCache) {
        this.evaluationFactory = evaluationFacotry;
        this.factory = factory;
        this.alreadyKnown = globalCache;
    }

    @Override
    public _AbstractRule nextRule(_AbstractGoal currentGoal, IterationInfo lastIteration) {
        _NbuSequent premise = (_NbuSequent)currentGoal;
        if (premise.isUp()) {
            Formula rightFormula = premise.getRight();
            if (rightFormula.isAtomic()) {
                FormulaProposition wff = (FormulaProposition)rightFormula;
                if (premise.inHistory(wff)) {
                    return new HistoryFailure(premise);
                }
                BitSetOfFormulas elegible = null;
                if (premise.isUpUnBlocked()) {
                    elegible = NbuSequentSupport.elegibleOrFormulasInLeftHandSide(premise, this.evaluationFactory.buildEvaluationFunction(premise));
                }
                if (wff.isFalse() && elegible == null) {
                    return new Up_Elim_False(premise);
                }
                LinkedList<_AbstractRule> addedRules = new LinkedList<_AbstractRule>();
                if (premise.getRight() != premise.getRight().getFactory().getFalse()) {
                    addedRules.add(new Up_Coercion(premise));
                }
                addedRules.add(new Up_Elim_False(premise));
                if (elegible != null) {
                    for (Formula eleg : elegible.getAllFormulas()) {
                        addedRules.addLast(new Up_Elim_OR(premise, eleg));
                    }
                }
                return new GenericMetaBacktrackRule("ON_ATOMIC_BACKTRACK_RULE", premise, addedRules);
            }
            switch (rightFormula.mainConnective()) {
                case AND: {
                    return new Up_Intro_AND(premise, rightFormula);
                }
                case IMPLIES: {
                    _NbuEvaluator evaluator = this.evaluationFactory.buildEvaluationFunction(premise);
                    if (evaluator.eval(rightFormula.immediateSubformulas()[0]) == NbuEvaluationValue.T) {
                        return new Up_Intro_IMPLIES_1(premise, rightFormula);
                    }
                    return new Up_Intro_IMPLIES_2(premise, rightFormula);
                }
                case OR: {
                    BitSetOfFormulas elegible;
                    Up_Intro_OR introOr = new Up_Intro_OR(premise, rightFormula);
                    if (premise.isUpUnBlocked() && (elegible = NbuSequentSupport.elegibleOrFormulasInLeftHandSide(premise, this.evaluationFactory.buildEvaluationFunction(premise))) != null) {
                        LinkedList<_AbstractRule> rulesToApply = new LinkedList<_AbstractRule>();
                        rulesToApply.add(introOr);
                        for (Formula wff : elegible.getAllFormulas()) {
                            rulesToApply.addLast(new Up_Elim_OR(premise, wff));
                        }
                        return new GenericMetaBacktrackRule("Or-Intro and OR-Eliminations Meta Backtrack rule", premise, rulesToApply);
                    }
                    return introOr;
                }
            }
            throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
        }
        return this.downSearch(premise);
    }

    _AbstractRule downSearch(_NbuSequent goal) {
        ProofSearchResult cacheResult = this.alreadyKnown.get(goal);
        if (cacheResult != null) {
            if (cacheResult == ProofSearchResult.SUCCESS) {
                return new RuleGlobalCacheSuccess(goal);
            }
            return null;
        }
        Formula rightFormula = goal.getRight();
        Collection<Formula> leftFormulas = goal.getAllLeftFormulas();
        if (leftFormulas != null) {
            for (Formula wff : leftFormulas) {
                if (!this.factory.positiveSubFormulasOf(wff).contains(rightFormula)) continue;
                _NbuSequent newDown = goal.clone();
                newDown.addRight(wff);
                newDown.markDown();
                _AbstractRule result = this.downTreeExpansionFrom(newDown, rightFormula);
                if (result == null) continue;
                this.alreadyKnown.put(goal, ProofSearchResult.SUCCESS);
                return result;
            }
        }
        return null;
    }

    _AbstractRule downTreeExpansionFrom(_NbuSequent downGoal, Formula searchingFor) {
        ProofSearchResult cacheResult = this.alreadyKnown.get(downGoal);
        if (cacheResult != null) {
            if (cacheResult == ProofSearchResult.SUCCESS) {
                return new RuleGlobalCacheSuccess(downGoal);
            }
            return null;
        }
        Formula rightFormula = downGoal.getRight();
        if (rightFormula.isAtomic() || rightFormula.mainConnective() == PropositionalConnective.OR) {
            this.alreadyKnown.put(downGoal, ProofSearchResult.SUCCESS);
            return new DownSearchSuccess(downGoal);
        }
        switch (rightFormula.mainConnective()) {
            case AND: {
                _AbstractRule result;
                _NbuSequent newGoal;
                Formula wff = rightFormula.immediateSubformulas()[0];
                if (this.factory.positiveSubFormulasOf(wff).contains(searchingFor)) {
                    if (this.verbose) {
                        this.println("elim_AND 1 ");
                    }
                    newGoal = downGoal.clone();
                    newGoal.addRight(wff);
                    newGoal.markDown();
                    result = this.downTreeExpansionFrom(newGoal, searchingFor);
                    if (result != null) {
                        this.alreadyKnown.put(downGoal, ProofSearchResult.SUCCESS);
                        return result;
                    }
                }
                if (this.factory.positiveSubFormulasOf(wff = rightFormula.immediateSubformulas()[1]).contains(searchingFor)) {
                    if (this.verbose) {
                        this.println("elim_AND 2 ");
                    }
                    newGoal = downGoal.clone();
                    newGoal.addRight(wff);
                    newGoal.markDown();
                    result = this.downTreeExpansionFrom(newGoal, searchingFor);
                    if (result != null) {
                        this.alreadyKnown.put(downGoal, ProofSearchResult.SUCCESS);
                        return result;
                    }
                }
                return null;
            }
            case IMPLIES: {
                _AbstractRule result;
                Engine engine;
                _NbuSequent newgoal = downGoal.clone();
                newgoal.addRight(rightFormula.immediateSubformulas()[0]);
                newgoal.markUpBlocked();
                if (this.verbose) {
                    this.println("================================ STARTING NEW ENGINE ");
                    engine = new Engine(new NbuProver(this.factory, new StrategyDownExpansion(this.factory, this.evaluationFactory, this.alreadyKnown)), newgoal, Engine.ExecutionMode.ENGINE_VERBOSE);
                } else {
                    engine = new Engine(new NbuProver(this.factory, new StrategyDownExpansion(this.factory, this.evaluationFactory, this.alreadyKnown)), newgoal);
                }
                if (this.verbose) {
                    this.println("elim_IMPLIES #1 ");
                }
                ProofSearchResult pfresult = engine.searchProof();
                if (this.verbose) {
                    this.println("================================ ENGINE RESULT " + (Object)((Object)pfresult));
                }
                if (pfresult == ProofSearchResult.FAILURE) {
                    this.alreadyKnown.put(downGoal, ProofSearchResult.FAILURE);
                    return null;
                }
                newgoal = downGoal.clone();
                newgoal.addRight(rightFormula.immediateSubformulas()[1]);
                newgoal.markDown();
                if (this.verbose) {
                    this.println("elim_IMPLIES #2 ");
                }
                if ((result = this.downTreeExpansionFrom(newgoal, searchingFor)) != null) {
                    this.alreadyKnown.put(downGoal, ProofSearchResult.SUCCESS);
                }
                return result;
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }

    void println(String s) {
        System.out.println(s);
    }
}

