/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp.strategy.commons;

import ipl.nbu.sequent._NbuSequent;
import ipl.nbu.tp.strategy.commons._GlobalCache;
import java.util.HashMap;
import java.util.LinkedList;
import jtabwb.engine.ProofSearchResult;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.SetTrieOfFormulas;

public class GlobalCacheOnSetTrie_HistoriesAsLists
implements _GlobalCache {
    private HashMap<Formula, LinkedList<Value>> success = new HashMap();
    private HashMap<Formula, LinkedList<Value>> failure = new HashMap();

    @Override
    public void put(_NbuSequent sequent, ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                this.addWithHistoryTo(this.success, sequent);
                return;
            }
            case FAILURE: {
                this.addWithHistoryTo(this.failure, sequent);
                return;
            }
        }
        throw new CaseNotImplementedImplementationError("Wrong value: " + (Object)((Object)result));
    }

    private void addWithHistoryTo(HashMap<Formula, LinkedList<Value>> map, _NbuSequent sequent) {
        Formula rightFormula = sequent.getRight();
        BitSetOfFormulas leftside = sequent.leftSide();
        BitSetOfFormulas history = sequent.getHistory();
        LinkedList<Value> values = map.get(rightFormula);
        if (values == null) {
            values = new LinkedList();
            Value v = new Value(history);
            v.settrie.insert(leftside);
            values.add(v);
            map.put(rightFormula, values);
        } else {
            boolean inserted = false;
            for (Value v : values) {
                if (!v.history.equals(history)) continue;
                v.settrie.insert(leftside);
                inserted = true;
                break;
            }
            if (!inserted) {
                Value v;
                v = new Value(history);
                v.settrie.insert(leftside);
                values.add(v);
            }
        }
    }

    @Override
    public ProofSearchResult get(_NbuSequent sequent) {
        Formula rightFormula = sequent.getRight();
        BitSetOfFormulas leftside = sequent.leftSide();
        BitSetOfFormulas history = sequent.getHistory();
        LinkedList<Value> values = this.success.get(rightFormula);
        if (values != null) {
            for (Value value : values) {
                if (!history.equals(value.history) || !value.settrie.containsSubsetOf(leftside)) continue;
                return ProofSearchResult.SUCCESS;
            }
        }
        if ((values = this.failure.get(rightFormula)) != null) {
            for (Value value : values) {
                if (!history.equals(value.history) || !value.settrie.containsSupersetOf(leftside)) continue;
                return ProofSearchResult.FAILURE;
            }
        }
        return null;
    }

    private static class Value {
        SetTrieOfFormulas settrie = new SetTrieOfFormulas();
        BitSetOfFormulas history;

        public Value(BitSetOfFormulas history) {
            this.history = history;
        }
    }
}

