/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp.strategy.commons;

import ipl.nbu.sequent._NbuSequent;
import ipl.nbu.tp.strategy.commons._GlobalCache;
import java.util.HashMap;
import jtabwb.engine.ProofSearchResult;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.SetTrieOfFormulas;

public class GlobalCacheOnSetTrie_HistoriesAsHashMap
implements _GlobalCache {
    private HashMap<Formula, HashMap<BitSetOfFormulas, SetTrieOfFormulas>> success = new HashMap();
    private HashMap<Formula, HashMap<BitSetOfFormulas, SetTrieOfFormulas>> failure = new HashMap();

    @Override
    public void put(_NbuSequent sequent, ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                this.addWithHistoryTo(this.success, sequent);
                return;
            }
            case FAILURE: {
                this.addWithHistoryTo(this.failure, sequent);
                return;
            }
        }
        throw new CaseNotImplementedImplementationError("Wrong value: " + (Object)((Object)result));
    }

    private void addWithHistoryTo(HashMap<Formula, HashMap<BitSetOfFormulas, SetTrieOfFormulas>> map, _NbuSequent sequent) {
        Formula rightFormula = sequent.getRight();
        BitSetOfFormulas leftside = sequent.leftSide();
        BitSetOfFormulas history = sequent.getHistory();
        HashMap<BitSetOfFormulas, SetTrieOfFormulas> values = map.get(rightFormula);
        if (values == null) {
            values = new HashMap();
            SetTrieOfFormulas settrie = new SetTrieOfFormulas();
            settrie.insert(leftside);
            values.put(history, settrie);
            map.put(rightFormula, values);
        } else {
            SetTrieOfFormulas settrie = values.get(history);
            if (settrie == null) {
                settrie = new SetTrieOfFormulas();
                settrie.insert(leftside);
                values.put(history, settrie);
            } else {
                settrie.insert(leftside);
            }
        }
    }

    @Override
    public ProofSearchResult get(_NbuSequent sequent) {
        SetTrieOfFormulas settrie;
        Formula rightFormula = sequent.getRight();
        BitSetOfFormulas leftside = sequent.leftSide();
        BitSetOfFormulas history = sequent.getHistory();
        HashMap<BitSetOfFormulas, SetTrieOfFormulas> values = this.success.get(rightFormula);
        if (values != null && (settrie = values.get(history)) != null && settrie.contains(leftside)) {
            return ProofSearchResult.SUCCESS;
        }
        values = this.failure.get(rightFormula);
        if (values != null && (settrie = values.get(history)) != null && settrie.contains(leftside)) {
            return ProofSearchResult.FAILURE;
        }
        return null;
    }
}

