/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp.strategy.commons;

import ipl.nbu.sequent._NbuSequent;
import ipl.nbu.tp.strategy.commons.ImplementationError;
import ipl.nbu.tp.strategy.commons._GlobalCache;
import java.util.HashMap;
import java.util.LinkedList;
import jtabwb.engine.ProofSearchResult;
import jtabwbx.prop.formula.Formula;

public class AttemptGlobalCache
implements _GlobalCache {
    private HashMap<Formula, LinkedList<Result>> alreadyKnown = new HashMap();

    @Override
    public void put(_NbuSequent sequent, ProofSearchResult result) {
        Formula rightFormula = sequent.getRight();
        LinkedList<Result> list = this.alreadyKnown.get(rightFormula);
        if (list != null) {
            list.add(new Result(sequent, result));
        } else {
            list = new LinkedList();
            list.add(new Result(sequent, result));
            this.alreadyKnown.put(rightFormula, list);
        }
    }

    @Override
    public ProofSearchResult get(_NbuSequent sequent) {
        Formula rightFormula = sequent.getRight();
        LinkedList<Result> hm = this.alreadyKnown.get(rightFormula);
        if (hm == null) {
            return null;
        }
        block4: for (Result result : hm) {
            switch (result.res) {
                case SUCCESS: {
                    if (!this.impliesRelativeSuccessOf(result.seq, sequent)) continue block4;
                    return ProofSearchResult.SUCCESS;
                }
                case FAILURE: {
                    if (!this.impliesRelativeFailureOf(result.seq, sequent)) continue block4;
                    return ProofSearchResult.FAILURE;
                }
                default: {
                    throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
                }
            }
        }
        return null;
    }

    public boolean impliesRelativeSuccessOf(_NbuSequent first, _NbuSequent second) {
        return first.leftSide().equals(second.leftSide()) && first.getHistory().superseteq(second.getHistory());
    }

    public boolean impliesRelativeFailureOf(_NbuSequent first, _NbuSequent second) {
        return first.leftSide().equals(second.leftSide()) && first.getHistory().subseteq(second.getHistory());
    }

    private static class Result {
        _NbuSequent seq;
        ProofSearchResult res;

        public Result(_NbuSequent seq, ProofSearchResult res) {
            this.seq = seq;
            this.res = res;
        }
    }
}

