/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp;

import ipl.nbu.evaluations._NbuEvaluationFactory;
import ipl.nbu.sequent.AvailableNbuSequentImplementations;
import ipl.nbu.sequent.NbuFormulaFactory;
import ipl.nbu.tp.AvailableNbuEvaluations;
import ipl.nbu.tp.AvailableStrategies;
import ipl.nbu.tp.CtreeLatexFormatter;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine._Prover;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwb.tracesupport._LatexSupport;
import jtabwb.util.ImplementationError;

public class NbuProver
implements _Prover,
_LatexSupport {
    public static String NBU_DESCRIPTION = "Nbu - Natural deduction calculus for IPL.";
    public static String NBU_NAME = "nbu";
    public static String NBU_VERSION = "0.1";
    public static AvailableNbuSequentImplementations DEFAULT_SEQ_IMPLEMENTATION = AvailableNbuSequentImplementations.SEQ_ON_BSF;
    public static AvailableNbuEvaluations DEFAULT_EVALUATION = AvailableNbuEvaluations.MINIMAL;
    public static AvailableStrategies DEFAULT_STRATEGY = AvailableStrategies.GOGC;
    private ProverName proverName;
    private NbuFormulaFactory formulaFactory;
    private _Strategy strategy;
    private _NbuEvaluationFactory evaluationFactory;
    private AvailableNbuSequentImplementations selectedSequentImplementation;
    private AvailableNbuEvaluations selectedEvaluation;
    private AvailableStrategies selectedStrategy;

    public NbuProver() {
        this.configure(new NbuFormulaFactory(), DEFAULT_STRATEGY, DEFAULT_SEQ_IMPLEMENTATION, DEFAULT_EVALUATION);
    }

    public NbuProver(NbuFormulaFactory factory, _Strategy strategy) {
        this.formulaFactory = factory;
        this.selectedEvaluation = AvailableNbuEvaluations.MINIMAL;
        this.strategy = strategy;
        this.selectedSequentImplementation = DEFAULT_SEQ_IMPLEMENTATION;
        this.selectedEvaluation = DEFAULT_EVALUATION;
        this.selectedStrategy = DEFAULT_STRATEGY;
        this.proverName = new ProverName(NBU_NAME, NBU_VERSION, this.proverVariantString());
    }

    private String proverVariantString() {
        return "seq=" + this.selectedSequentImplementation.getName() + ", strategy=" + this.selectedStrategy.name() + ", eval=" + this.selectedEvaluation.getName();
    }

    @Override
    public _Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ProverName getProverName() {
        return this.proverName;
    }

    @Override
    public ProvabilityStatus statusFor(ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                return ProvabilityStatus.PROVABLE;
            }
            case FAILURE: {
                return ProvabilityStatus.UNPROVABLE;
            }
        }
        throw new ImplementationError();
    }

    public void configure(NbuFormulaFactory factory, AvailableStrategies strategy, AvailableNbuSequentImplementations seqimpl, AvailableNbuEvaluations eval) {
        this.formulaFactory = factory;
        this.selectedStrategy = strategy;
        this.selectedSequentImplementation = seqimpl;
        this.selectedEvaluation = eval;
        this.evaluationFactory = AvailableNbuEvaluations.getEvaluationFactory(eval, this.formulaFactory);
        this.strategy = AvailableStrategies.getStrategy(strategy, this.formulaFactory, this.evaluationFactory);
        this.proverName = new ProverName(NBU_NAME, NBU_VERSION, this.proverVariantString());
    }

    @Override
    public _LatexCTreeFormatter getLatexProofFormatter() {
        return new CtreeLatexFormatter();
    }
}

