/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp;

import ipl.nbu.calculus._NBUAbstractRule;
import ipl.nbu.sequent.NbuSequentLatexFormatter;
import ipl.nbu.sequent._NbuSequent;
import ipl.nbu.tp.strategy.commons.HistoryFailure;
import ipl.nbu.tp.strategy.commons.PositiveSubformulaFailure;
import ipl.nbu.tp.strategy.commons.RuleGlobalCacheFailure;
import ipl.nbu.tp.strategy.commons.RuleGlobalCacheSuccess;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.tracesupport.CTree;
import jtabwb.tracesupport.LatexTranslator;
import jtabwb.tracesupport._LatexCTreeFormatter;

class CtreeLatexFormatter
implements _LatexCTreeFormatter {
    private final String EVAL_MACRO = "\n\\newcommand{\\etildename}{\\tilde{\\mathcal{E}}}\n\\newcommand{\\etilde}[1]{\\etildename(#1)}";
    private NbuSequentLatexFormatter sequentFormatter = new NbuSequentLatexFormatter();

    @Override
    public String getPreamble() {
        return "\\newcommand{\\seqnd}[2]{ [\\ifthenelse{\\isempty{#1}}{\\,}{#1}\\vdash #2] }\\newcommand{\\upu}{\\!\\Uparrow^{u}}\\newcommand{\\upb}{\\!\\Uparrow^{b}}\\newcommand{\\down}{\\!\\downarrow}\n\\newcommand{\\etildename}{\\tilde{\\mathcal{E}}}\n\\newcommand{\\etilde}[1]{\\etildename(#1)}";
    }

    @Override
    public String getIntro() {
        return "\\subsection*{Legenda}\n\\begin{itemize}\n\\item The sequent in the conclusion of every rule is indexed by an integer. \\item $\\sigma_i$ is an abbreviation for the sequent with index $i$ and $\\Gamma_i$ denotes the left-hand side of sequent $\\sigma_i$.\\item $\\mathcal{E}$ is the evaluation function.\\end{itemize}\\par\\vspace*{4ex}";
    }

    @Override
    public LatexTranslator.ProofStyle proofStyle() {
        return LatexTranslator.ProofStyle.SEQUENT;
    }

    @Override
    public String format(_AbstractGoal nodeSet) {
        return this.sequentFormatter.toLatex((_NbuSequent)nodeSet);
    }

    @Override
    public String formatRuleName(_AbstractRule rule) {
        if (rule instanceof HistoryFailure) {
            return "\\textrm{History-failure}";
        }
        if (rule instanceof RuleGlobalCacheFailure) {
            return "\\textrm{GlobalCache-Failure}";
        }
        if (rule instanceof RuleGlobalCacheSuccess) {
            return "\\textrm{GlobalCache-Success}";
        }
        if (rule instanceof PositiveSubformulaFailure) {
            return "\\textrm{PositiveSubformula-Failure}";
        }
        _NBUAbstractRule r = (_NBUAbstractRule)rule;
        switch (r.getRuleIdentifier()) {
            case COERCION_UP: {
                return "\\down\\Uparrow";
            }
            case ELIM_AND_DOWN: {
                return "\\land\\textrm{E}";
            }
            case ELIM_OR_UP: {
                return "\\lor\\textrm{E}";
            }
            case ELIM_IMPLIES_DOWN: {
                return "\\to\\textrm{E}";
            }
            case ELIM_FALSE_UP: {
                return "\\bot\\textrm{E}";
            }
            case INTRO_AND_UP: {
                return "\\land\\textrm{I}";
            }
            case INTRO_OR_UP: {
                return "\\lor\\textrm{I}";
            }
            case INTRO_IMPLIES_1_UP: {
                return "\\to\\textrm{I}_1";
            }
            case INTRO_IMPLIES_2_UP: {
                return "\\to\\textrm{I}_2";
            }
            case ID_CLASH_DETECTION: {
                return "\\mathrm{Id}";
            }
        }
        return null;
    }

    @Override
    public boolean generateNodeSetIndex() {
        return true;
    }

    @Override
    public boolean generateRuleIndex() {
        return false;
    }

    @Override
    public String pre(CTree ctree) {
        return null;
    }

    @Override
    public boolean generateFailureGoalAnnotations() {
        return true;
    }

    @Override
    public String post(CTree ctree) {
        return null;
    }
}

