/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp;

import ferram.rtoptions._NamedArgument;
import ipl.nbu.evaluations._NbuEvaluationFactory;
import ipl.nbu.sequent.NbuFormulaFactory;
import ipl.nbu.tp.strategy.down.StrategyDownExpansion;
import ipl.nbu.tp.strategy.go_gc.StrategyGOGC;
import ipl.nbu.tp.strategy.go_gc_2.StrategyGOGC_2;
import ipl.nbu.tp.strategy.go_gc_3.StrategyGOGC_3;
import ipl.nbu.tp.strategy.go_gc_4.StrategyGOGC_4;
import ipl.nbu.tp.strategy.go_genrules.StreategyGOGC_GeneralizedRules;
import ipl.nbu.tp.strategy.go_genrules_2.StreategyGOGC_GeneralizedRulesGCOnUpSequents;
import ipl.nbu.tp.strategy.go_naive.StrategyGONaive;
import jtabwb.engine._Strategy;
import jtabwb.util.ImplementationError;

public enum AvailableStrategies implements _NamedArgument<AvailableStrategies>
{
    GONAIVE("plain", "Goal oriented proof-search with no caching"),
    GOGC("gc", "Goal oriented proof-search with global caching on set-trie for down sequents and up-sequents generating backtrack."),
    GOGC_2("gc2", "Goal oriented proof-search with global caching for down sequents and up-sequents generating backtrack."),
    GOGC_3("gc3", "Variant of gogc2 with global caching for false elimination and down-sequents only."),
    GOGC_4("gc4", "Variant of gogc3 with reconsideration of backtrack formulas on resume."),
    GOGEN("gen", "Goal oriented with generic rules and global caching on set-tries."),
    GOGEN2("gen2", "Goal oriented with generic rules and global caching for false elimination, down sequents and up-sequents generating backtrack."),
    DOWN("down", "Down expansion.");

    private String name;
    private String description;

    private AvailableStrategies(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public AvailableStrategies getValue() {
        return this;
    }

    static _Strategy getStrategy(AvailableStrategies strategy, NbuFormulaFactory formulaFactory, _NbuEvaluationFactory evaluationFactory) {
        switch (strategy) {
            case GOGC: {
                return new StrategyGOGC(evaluationFactory);
            }
            case GOGC_2: {
                return new StrategyGOGC_2(evaluationFactory);
            }
            case GOGC_3: {
                return new StrategyGOGC_3(evaluationFactory);
            }
            case GOGC_4: {
                return new StrategyGOGC_4(evaluationFactory);
            }
            case GOGEN: {
                return new StreategyGOGC_GeneralizedRules(evaluationFactory);
            }
            case GOGEN2: {
                return new StreategyGOGC_GeneralizedRulesGCOnUpSequents(evaluationFactory);
            }
            case DOWN: {
                return new StrategyDownExpansion(formulaFactory, evaluationFactory);
            }
            case GONAIVE: {
                return new StrategyGONaive(evaluationFactory);
            }
        }
        throw new ImplementationError();
    }
}

