/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.tp;

import ferram.rtoptions._NamedArgument;
import ipl.nbu.evaluations.CoverEvaluationFactory;
import ipl.nbu.evaluations.GCCoverEvaluationFactory;
import ipl.nbu.evaluations.ImplementationError;
import ipl.nbu.evaluations.MinimalEvaluationFactory;
import ipl.nbu.evaluations.NbuSimplificationEvaluationFactory;
import ipl.nbu.evaluations._NbuEvaluationFactory;
import ipl.nbu.sequent.NbuFormulaFactory;

public enum AvailableNbuEvaluations implements _NamedArgument<AvailableNbuEvaluations>
{
    MINIMAL("min", "Minimal...."),
    GBU("gbu", "Gbu evaluation"),
    GCCOVER("gccover", "Cover with global cache"),
    COVER("cover", "Cover");

    private String name;
    private String description;

    private AvailableNbuEvaluations(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public AvailableNbuEvaluations getValue() {
        return this;
    }

    public static _NbuEvaluationFactory getEvaluationFactory(AvailableNbuEvaluations eval, NbuFormulaFactory formulaFactory) {
        switch (eval) {
            case COVER: {
                return new CoverEvaluationFactory();
            }
            case GCCOVER: {
                return new GCCoverEvaluationFactory();
            }
            case MINIMAL: {
                return new MinimalEvaluationFactory();
            }
            case GBU: {
                return new NbuSimplificationEvaluationFactory(formulaFactory);
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }
}

