/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.sequent;

import ipl.nbu.evaluations.NbuEvaluationValue;
import ipl.nbu.evaluations._NbuEvaluator;
import ipl.nbu.sequent._NbuSequent;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;

public class NbuSequentSupport {
    public static BitSetOfFormulas elegibleANDFormulasFor(_NbuSequent goal, Formula toProve) {
        if (goal.leftSideIsEmpty()) {
            return null;
        }
        BitSetOfFormulas andFormulas = goal.positiveSubformulasOfLeftHandSide(FormulaType.AND_WFF);
        if (andFormulas.cardinality() == 0) {
            return null;
        }
        BitSetOfFormulas elegible = new BitSetOfFormulas(toProve.getFactory());
        for (Formula wff : andFormulas) {
            if (wff.immediateSubformulas()[0] != toProve && wff.immediateSubformulas()[1] != toProve) continue;
            elegible.add(wff);
        }
        return elegible.cardinality() == 0 ? null : elegible;
    }

    public static BitSetOfFormulas elegibleIMPLIESFormulasFor(_NbuSequent goal, Formula toProve) {
        if (goal.leftSideIsEmpty()) {
            return null;
        }
        BitSetOfFormulas implicativeFormulas = goal.positiveSubformulasOfLeftHandSide(FormulaType.IMPLIES_WFF);
        if (implicativeFormulas.cardinality() == 0) {
            return null;
        }
        BitSetOfFormulas elegible = new BitSetOfFormulas(toProve.getFactory());
        for (Formula wff : implicativeFormulas) {
            if (wff.immediateSubformulas()[1] != toProve) continue;
            elegible.add(wff);
        }
        return elegible.cardinality() == 0 ? null : elegible;
    }

    public static BitSetOfFormulas elegibleOrFormulasInLeftHandSide(_NbuSequent context, _NbuEvaluator evaluator) {
        if (context.leftSideIsEmpty()) {
            return null;
        }
        BitSetOfFormulas orSubFormulasOfLeftSide = context.positiveSubformulasOfLeftHandSide(FormulaType.OR_WFF);
        if (orSubFormulasOfLeftSide.cardinality() == 0) {
            return null;
        }
        BitSetOfFormulas elegible = new BitSetOfFormulas(orSubFormulasOfLeftSide.getFactory());
        for (Formula formula : orSubFormulasOfLeftSide) {
            if (evaluator.eval(formula.immediateSubformulas()[0]) != NbuEvaluationValue.F || evaluator.eval(formula.immediateSubformulas()[1]) != NbuEvaluationValue.F) continue;
            elegible.add(formula);
        }
        return elegible.cardinality() == 0 ? null : elegible;
    }
}

