/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.sequent;

import ipl.nbu.sequent.NbuFormulaFactory;
import ipl.nbu.sequent._NbuSequent;
import java.util.Collection;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.SingleSuccedentSequentOnBSF;

public class NbuSequentOnBSF
extends SingleSuccedentSequentOnBSF
implements _NbuSequent {
    private static final int DOWN = 0;
    private static final int UP_BLOCKED = 1;
    private static final int UP_UNBLOCKED = 2;
    private int marking = 0;
    private BitSetOfFormulas history;
    private BitSetOfFormulas positiveSubformulasOfLeftHandSide = null;

    public NbuSequentOnBSF(NbuFormulaFactory factory) {
        super(factory);
        this.history = new BitSetOfFormulas(factory);
        this.positiveSubformulasOfLeftHandSide = new BitSetOfFormulas(factory);
    }

    @Override
    public void markUpBlocked() {
        this.marking = 1;
    }

    @Override
    public void markUpUnblocked() {
        this.marking = 2;
    }

    @Override
    public boolean isUpBlocked() {
        return this.marking == 1;
    }

    @Override
    public boolean isUpUnBlocked() {
        return this.marking == 2;
    }

    @Override
    public void markDown() {
        this.marking = 0;
    }

    @Override
    public boolean isUp() {
        return this.marking != 0;
    }

    @Override
    public boolean isDown() {
        return this.marking == 0;
    }

    @Override
    public void addLeft(Formula wff) {
        super.addLeft(wff);
        this.positiveSubformulasOfLeftHandSide.or(((NbuFormulaFactory)this.getFormulaFactory()).positiveSubFormulasOf(wff));
    }

    @Override
    public boolean inHistory(Formula wff) {
        return this.history.contains(wff);
    }

    @Override
    public void addToHistory(Formula wff) {
        this.history.add(wff);
    }

    @Override
    public void clearHistory() {
        this.history = new BitSetOfFormulas(this.history.getFactory());
    }

    @Override
    public NbuSequentOnBSF clone() {
        NbuSequentOnBSF cloned = (NbuSequentOnBSF)super.clone();
        cloned.history = this.history.clone();
        cloned.positiveSubformulasOfLeftHandSide = this.positiveSubformulasOfLeftHandSide.clone();
        cloned.marking = this.marking;
        return cloned;
    }

    @Override
    public Collection<Formula> getHistoryFormulas() {
        return this.history.getAllFormulas();
    }

    @Override
    public String format() {
        return this.toString();
    }

    @Override
    public String toString() {
        String str = "";
        Collection<Formula> cleft = this.getAllLeftFormulas();
        if (cleft != null) {
            Formula[] left = cleft.toArray(new Formula[cleft.size()]);
            int i = 0;
            while (i < left.length) {
                str = String.valueOf(str) + left[i].toString() + (i < left.length - 1 ? ", " : "");
                ++i;
            }
        }
        Formula right = this.getRight();
        String hstr = "";
        Collection<Formula> hf = this.history.getAllFormulas();
        if (hf != null) {
            Formula[] a = hf.toArray(new Formula[hf.size()]);
            int i = 0;
            while (i < a.length) {
                hstr = String.valueOf(hstr) + a[i] + (i < a.length - 1 ? ", " : "");
                ++i;
            }
        }
        return String.valueOf(str) + (this.marking == 0 ? "" : (this.marking == 1 ? "[B]" : "[U]")) + "==>" + (this.marking == 0 ? "[down]" : "[up]") + "\n" + (right == null ? "" : right.toString()) + "\nHistory:{" + hstr + "}";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.history == null ? 0 : this.history.hashCode());
        result = 31 * result + this.marking;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NbuSequentOnBSF other = (NbuSequentOnBSF)obj;
        if (this.marking != other.marking) {
            return false;
        }
        return !(this.history == null ? other.history != null : !this.history.equals(other.history));
    }

    @Override
    public BitSetOfFormulas positiveSubformulasOfLeftHandSide() {
        return this.positiveSubformulasOfLeftHandSide.clone();
    }

    @Override
    public BitSetOfFormulas positiveSubformulasOfLeftHandSide(FormulaType type) {
        BitSetOfFormulas pos = this.positiveSubformulasOfLeftHandSide().clone();
        pos.and(((NbuFormulaFactory)this.getFormulaFactory()).getGeneratedFormulasOfType(type));
        return pos;
    }

    @Override
    public boolean isFalseInPositiveSubformulasOfLeftHandSide() {
        return this.positiveSubformulasOfLeftHandSide.contains(this.getFormulaFactory().FALSE);
    }

    @Override
    public boolean positiveSubformulaOfLeftHandSideContains(Formula wff) {
        return this.positiveSubformulasOfLeftHandSide.contains(wff);
    }

    @Override
    public BitSetOfFormulas getHistory() {
        return this.history;
    }

    @Override
    public boolean isHistoryEmpty() {
        return this.history.isEmpty();
    }
}

