/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.sequent;

import ipl.nbu.sequent._NbuSequent;
import jtabwbx.prop.formula.FormulaLatexFormatter;

public class NbuSequentLatexFormatter {
    public static final String LATEX_MACROS = "\\newcommand{\\seqnd}[2]{ [\\ifthenelse{\\isempty{#1}}{\\,}{#1}\\vdash #2] }\\newcommand{\\upu}{\\!\\Uparrow^{u}}\\newcommand{\\upb}{\\!\\Uparrow^{b}}\\newcommand{\\down}{\\!\\downarrow}";
    static final String SEQ_FORMAT = "\\seqnd{%s}{%s %s} \\{%s\\}";
    private FormulaLatexFormatter formulaFormatter;

    public NbuSequentLatexFormatter() {
        this.formulaFormatter = new FormulaLatexFormatter();
    }

    public NbuSequentLatexFormatter(FormulaLatexFormatter formulaFormatter) {
        this.formulaFormatter = formulaFormatter;
    }

    public String toLatex(_NbuSequent seq) {
        String arrow = "";
        if (seq.isUpBlocked()) {
            arrow = "\\upb";
        }
        if (seq.isUpUnBlocked()) {
            arrow = "\\upu";
        }
        if (seq.isDown()) {
            arrow = "\\down";
        }
        String s = String.format(SEQ_FORMAT, this.formulaFormatter.toLatex(seq.getAllLeftFormulas(), ", "), this.formulaFormatter.toLatex(seq.getRight()), arrow, this.formulaFormatter.toLatex(seq.getHistoryFormulas(), ",  "));
        return s;
    }
}

