/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.launcher;

import ipl.nbu.launcher.InitialNodeSetBuilder;
import ipl.nbu.launcher.Log;
import ipl.nbu.launcher.MSG;
import ipl.nbu.launcher.SelectableEvaluations;
import ipl.nbu.launcher.SelectableSequentsImplementation;
import ipl.nbu.launcher.SelectableStrategies;
import ipl.nbu.launcher.SingelExecutionConfigurator;
import ipl.nbu.sequent.AvailableNbuSequentImplementations;
import ipl.nbu.tp.AvailableNbuEvaluations;
import ipl.nbu.tp.AvailableStrategies;
import ipl.nbu.tp.NbuProver;
import jtabwb.launcher.Launcher;
import jtabwbx.problems.ILTPProblemReader;
import jtabwbx.problems.JTabWbSimpleProblemReader;
import jtabwbx.problems.PlainProblemReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Main {
    private static String FORMULA_SYNTAX_DESCRIPTION = "Syntax of formulas\n  atoms: Java identifiers\nlogical: false, & (and), | (or), ~ (not), -> (implies), <=> (iff)\n  notes: (~ A) is translated as (A -> false)\n         (A <=> B) is translated as ((A -> B) & (B -> A))";
    static final String DEFAULT_MODEL_FILE_NAME = "model.tex";
    private final Class<NbuProver> NBU_PROVER_CLASS = NbuProver.class;
    private final String NBU_PROVER_NAME = "nbu";
    static AvailableNbuSequentImplementations DEFAULT_SEQ_IMPLEMENTATION = NbuProver.DEFAULT_SEQ_IMPLEMENTATION;
    static AvailableNbuEvaluations DEFAULT_EVALUATION = NbuProver.DEFAULT_EVALUATION;
    static AvailableStrategies DEFAULT_STRATEGY = NbuProver.DEFAULT_STRATEGY;
    private SelectableEvaluations mngrEvaluations;
    private SelectableSequentsImplementation mngrSequentImplementations;
    private SelectableStrategies mngrStrategies;
    private Log LOG = new Log();
    private Launcher launcher = new Launcher();
    private AvailableNbuSequentImplementations selectedSequentImplementation;
    private AvailableStrategies selectedStrategy;
    private AvailableNbuEvaluations selectedEvaluation;

    private Main() {
        this.mngrSequentImplementations = new SelectableSequentsImplementation();
        this.mngrSequentImplementations.setDefault(DEFAULT_SEQ_IMPLEMENTATION);
        this.mngrEvaluations = new SelectableEvaluations();
        this.mngrEvaluations.setDefault(DEFAULT_EVALUATION);
        this.mngrStrategies = new SelectableStrategies();
        this.mngrStrategies.setDefault(DEFAULT_STRATEGY);
        this.selectedStrategy = DEFAULT_STRATEGY;
        this.selectedSequentImplementation = DEFAULT_SEQ_IMPLEMENTATION;
        this.selectedEvaluation = DEFAULT_EVALUATION;
    }

    private Options buildCmdLineOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)CmdLineOptionsNames.STRATEGY).hasArg(true).desc(MSG.getMsg("Define the strategy used by the prover. Available strategies (* is default): %s", this.mngrStrategies.getNames())).build());
        options.addOption(Option.builder((String)CmdLineOptionsNames.EVALUATION).hasArg(true).desc(MSG.getMsg("Define the evaluation used by the prover. Available evaluations (* is default): %s", this.mngrEvaluations.getNames())).build());
        options.addOption(Option.builder().longOpt(CmdLineOptionsNames.LONG_NAME_LIST_STRATEGIES).hasArg(false).desc("Prints available strategies  of the prover and exit.").build());
        options.addOption(Option.builder().longOpt(CmdLineOptionsNames.LONG_NAME_LIST_EVALUATIONS).hasArg(false).desc("Prints the available evaluations and exit.").build());
        return options;
    }

    private void processCommandLineOptions(String[] args) {
        String optValue;
        Launcher.LaunchConfiguration launcherConfiguration = this.launcher.processCmdLineArguments(args);
        CommandLine commandLine = launcherConfiguration.getCommandLine();
        if (commandLine.hasOption(CmdLineOptionsNames.LONG_NAME_LIST_SEQ_IMPLEMENTATIONS)) {
            this.LOG.info("Available sequents implementation (* is default value)\n%s", this.mngrSequentImplementations.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.LONG_NAME_LIST_STRATEGIES)) {
            this.LOG.info("Available strategies (* is default value)\n%s", this.mngrStrategies.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.LONG_NAME_LIST_EVALUATIONS)) {
            this.LOG.info("Available evaluations (* is default value)\n%s", this.mngrEvaluations.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.SEQUENTS_IMPLEMENTATIO)) {
            optValue = commandLine.getOptionValue(CmdLineOptionsNames.SEQUENTS_IMPLEMENTATIO);
            AvailableNbuSequentImplementations seqimpl = this.mngrSequentImplementations.searchByName(optValue);
            if (seqimpl == null) {
                this.LOG.error("[%s] is not the name of a sequent implementation.", optValue);
                System.exit(1);
            } else {
                this.selectedSequentImplementation = seqimpl;
            }
        } else {
            this.selectedSequentImplementation = DEFAULT_SEQ_IMPLEMENTATION;
        }
        if (commandLine.hasOption(CmdLineOptionsNames.STRATEGY)) {
            optValue = commandLine.getOptionValue(CmdLineOptionsNames.STRATEGY);
            AvailableStrategies var = this.mngrStrategies.searchByName(optValue);
            if (var == null) {
                this.LOG.error("[%s] is not the name of a strategy.", optValue);
                System.exit(1);
            } else {
                this.selectedStrategy = var;
            }
        } else {
            this.selectedStrategy = DEFAULT_STRATEGY;
        }
        if (commandLine.hasOption(CmdLineOptionsNames.EVALUATION)) {
            optValue = commandLine.getOptionValue(CmdLineOptionsNames.EVALUATION);
            AvailableNbuEvaluations eval = this.mngrEvaluations.searchByName(optValue);
            if (eval == null) {
                this.LOG.error("[%s] is not the name of an evaluation.", optValue);
                System.exit(1);
            } else {
                this.selectedEvaluation = eval;
            }
        } else {
            this.selectedEvaluation = DEFAULT_EVALUATION;
        }
    }

    private void start(String[] args) {
        this.launcher.configLauncherName(this.getClass().getCanonicalName());
        this.launcher.configStandardInputReader(new PlainProblemReader());
        this.launcher.optConfigInputSyntax(FORMULA_SYNTAX_DESCRIPTION);
        this.launcher.optConfigCmdLineOptions(this.buildCmdLineOptions());
        this.launcher.configProblemDescriptionReader("iltp", ILTPProblemReader.class);
        this.launcher.configProblemDescriptionReader("plain", PlainProblemReader.class);
        this.launcher.configProblemDescriptionReader("jtw", JTabWbSimpleProblemReader.class, true);
        InitialNodeSetBuilder i = new InitialNodeSetBuilder();
        this.launcher.configInitialNodeSetBuilder(i);
        this.launcher.configTheoremProver("nbu", this.NBU_PROVER_CLASS, true);
        this.processCommandLineOptions(args);
        this.launcher.optConfigSingleExecutionConfigurator(new SingelExecutionConfigurator(i, this.selectedStrategy, this.selectedSequentImplementation, this.selectedEvaluation));
        this.launcher.launch();
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.start(args);
    }

    private static class CmdLineOptionsNames {
        static String SEQUENTS_IMPLEMENTATIO = "seq";
        static String STRATEGY = "st";
        static String EVALUATION = "ev";
        static String LONG_NAME_LIST_SEQ_IMPLEMENTATIONS = "list-seq";
        static String LONG_NAME_LIST_STRATEGIES = "list-strategies";
        static String LONG_NAME_LIST_EVALUATIONS = "list-evaluations";

        private CmdLineOptionsNames() {
        }
    }
}

