/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.launcher;

import ipl.nbu.sequent.AvailableNbuSequentImplementations;
import ipl.nbu.sequent.NbuFormulaFactory;
import ipl.nbu.sequent.NbuSequentOnBSF;
import ipl.nbu.sequent._NbuSequent;
import java.util.LinkedList;
import jtabwb.launcher.InitialGoalBuilderException;
import jtabwb.launcher._InitialGoalBuilder;
import jtabwb.util.ImplementationError;
import jtabwbx.problems.ILTPProblem;
import jtabwbx.problems.JTabWbSimpleProblem;
import jtabwbx.problems.ProblemDescription;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.parser.FormulaParseException;
import jtabwbx.prop.parser.PropositionalFormulaParser;

public class InitialNodeSetBuilder
implements _InitialGoalBuilder {
    private AvailableNbuSequentImplementations selectedImplementation;
    private NbuFormulaFactory formulaFactory;

    public void setSequentImplementation(AvailableNbuSequentImplementations selectedImplementation) {
        this.selectedImplementation = selectedImplementation;
    }

    public void setFormulaFactory(NbuFormulaFactory factory) {
        this.formulaFactory = factory;
    }

    @Override
    public _NbuSequent buildInitialNodeSet(ProblemDescription inputProblem) throws InitialGoalBuilderException {
        if (inputProblem instanceof JTabWbSimpleProblem) {
            return this.buildFrom((JTabWbSimpleProblem)inputProblem);
        }
        if (inputProblem instanceof ILTPProblem) {
            return this.buildFrom((ILTPProblem)inputProblem);
        }
        throw new ImplementationError("Unkonw problem description.");
    }

    private _NbuSequent getEmptyNodeSet(AvailableNbuSequentImplementations impl, NbuFormulaFactory formulaFactory) {
        switch (impl) {
            case SEQ_ON_BSF: {
                NbuSequentOnBSF nodeSet = new NbuSequentOnBSF(formulaFactory);
                nodeSet.markUpUnblocked();
                return nodeSet;
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }

    private _NbuSequent buildFrom(JTabWbSimpleProblem inputProblem) throws InitialGoalBuilderException {
        PropositionalFormulaParser parser = new PropositionalFormulaParser();
        String conjecture = inputProblem.getConjecture();
        if (conjecture == null) {
            throw new InitialGoalBuilderException("No problem formula defined in the input problem.");
        }
        Formula wff = null;
        try {
            wff = this.formulaFactory.buildFrom(parser.parse(conjecture));
        }
        catch (FormulaParseException e) {
            throw new InitialGoalBuilderException(e.getMessage());
        }
        _NbuSequent nodeSet = this.getEmptyNodeSet(this.selectedImplementation, this.formulaFactory);
        nodeSet.addRight(wff);
        return nodeSet;
    }

    private _NbuSequent buildFrom(ILTPProblem inputProblem) throws InitialGoalBuilderException {
        PropositionalFormulaParser parser = new PropositionalFormulaParser();
        String conjecture = inputProblem.getConjecture();
        if (conjecture == null) {
            throw new InitialGoalBuilderException("No problem formula defined in the input problem.");
        }
        Formula right = null;
        LinkedList<Formula> left = null;
        try {
            right = this.formulaFactory.buildFrom(parser.parse(conjecture));
            if (inputProblem.getAxioms() != null) {
                left = new LinkedList<Formula>();
                for (String axiom : inputProblem.getAxioms()) {
                    left.add(this.formulaFactory.buildFrom(parser.parse(axiom)));
                }
            }
        }
        catch (FormulaParseException e) {
            throw new InitialGoalBuilderException(e.getMessage());
        }
        _NbuSequent nodeSet = this.getEmptyNodeSet(this.selectedImplementation, this.formulaFactory);
        nodeSet.addRight(right);
        if (left != null) {
            for (Formula axiom : left) {
                nodeSet.addLeft(axiom);
            }
        }
        return nodeSet;
    }
}

