/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.evaluations;

import ipl.nbu.evaluations.ImplementationError;
import ipl.nbu.evaluations.NbuEvaluationValue;
import ipl.nbu.evaluations._NbuEvaluator;
import ipl.nbu.sequent._NbuSequent;
import java.util.HashMap;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class GCCoverEvaluation
implements _NbuEvaluator {
    private _NbuSequent context;
    private HashMap<Formula, Boolean> globalCache;

    public GCCoverEvaluation(_NbuSequent context) {
        this.context = context;
        this.globalCache = new HashMap();
    }

    @Override
    public _SingleSuccedentSequent getContext() {
        return this.context;
    }

    @Override
    public NbuEvaluationValue eval(Formula formula) {
        return this.cover(this.context.leftSide(), formula) ? NbuEvaluationValue.T : NbuEvaluationValue.F;
    }

    private boolean cover(BitSetOfFormulas context, Formula formula) {
        Boolean result = this.globalCache.get(formula);
        if (result != null) {
            return result;
        }
        if (context.contains(formula)) {
            result = true;
        } else if (formula.isAtomic()) {
            result = false;
        } else {
            Formula left = formula.immediateSubformulas()[0];
            Formula right = formula.immediateSubformulas()[1];
            switch (formula.mainConnective()) {
                case AND: {
                    result = this.cover(context, left) && this.cover(context, right);
                    break;
                }
                case OR: {
                    result = this.cover(context, left) || this.cover(context, right);
                    break;
                }
                case IMPLIES: {
                    result = this.cover(context, right);
                    break;
                }
                default: {
                    throw new ImplementationError();
                }
            }
        }
        this.globalCache.put(formula, result);
        return result;
    }
}

