/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.evaluations;

import ipl.nbu.evaluations.ImplementationError;
import ipl.nbu.evaluations.NbuEvaluationValue;
import ipl.nbu.evaluations._NbuEvaluator;
import ipl.nbu.sequent._NbuSequent;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class CoverEvaluation
implements _NbuEvaluator {
    private _NbuSequent context;

    public CoverEvaluation(_NbuSequent context) {
        this.context = context;
    }

    @Override
    public _SingleSuccedentSequent getContext() {
        return this.context;
    }

    @Override
    public NbuEvaluationValue eval(Formula formula) {
        if (this.cover(this.context, formula)) {
            return NbuEvaluationValue.T;
        }
        return NbuEvaluationValue.F;
    }

    private boolean cover(_SingleSuccedentSequent context, Formula formula) {
        if (context.containsLeft(formula)) {
            return true;
        }
        if (formula.isAtomic()) {
            return false;
        }
        Formula left = formula.immediateSubformulas()[0];
        Formula right = formula.immediateSubformulas()[1];
        switch (formula.mainConnective()) {
            case AND: {
                return this.cover(context, left) && this.cover(context, right);
            }
            case OR: {
                return this.cover(context, left) || this.cover(context, right);
            }
            case IMPLIES: {
                return this.cover(context, right);
            }
        }
        throw new ImplementationError();
    }
}

