/*
 * Decompiled with CFR 0.152.
 */
package ipl.nbu.evaluations;

import ipl.nbu.evaluations.NbuEvaluationValue;
import ipl.nbu.sequent.NbuFormulaFactory;
import ipl.nbu.sequent._NbuSequent;
import java.util.HashMap;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;

public class ContextualSimplification {
    private NbuFormulaFactory factory = new NbuFormulaFactory();
    private HashMap<Formula, Formula> translation = new HashMap();

    public ContextualSimplification(_NbuSequent context, NbuFormulaFactory originalFactory) {
        for (Formula original : originalFactory.generatedFormulas()) {
            this.translation.put(original, this.factory.build(original));
        }
    }

    public Formula reduction(BitSetOfFormulas context, Formula wff) {
        if (context.contains(wff)) {
            return this.factory.getTrue();
        }
        if (wff.isAtomic()) {
            return wff;
        }
        Formula[] sub = wff.immediateSubformulas();
        PropositionalConnective con = wff.mainConnective();
        Formula[] subeval = new Formula[]{this.reduction(context, sub[0]), this.reduction(context, sub[1])};
        Formula result = this.factory.buildCompound(con, subeval);
        return result.calculateBooleanSimplification();
    }

    public NbuEvaluationValue evalReduction(_NbuSequent sequent, Formula wff) {
        BitSetOfFormulas context = new BitSetOfFormulas(this.factory);
        for (Formula f : sequent.leftSide()) {
            context.add(this.translation.get(f));
        }
        Formula red = this.reduction(context, this.translation.get(wff));
        if (red.isTrue()) {
            return NbuEvaluationValue.T;
        }
        return NbuEvaluationValue.F;
    }
}

