/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Collection;
import java.util.Iterator;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula._Sequent;

public class SequentOnBSF
implements _Sequent,
Cloneable {
    private FormulaFactory formulaFactory;
    private BitSetOfFormulas leftside;
    private BitSetOfFormulas rightside;

    public SequentOnBSF(FormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
        this.leftside = new BitSetOfFormulas(formulaFactory);
        this.rightside = new BitSetOfFormulas(formulaFactory);
    }

    @Override
    public void addLeft(Formula wff) {
        this.leftside.add(wff);
    }

    public void addLeft(BitSetOfFormulas formulas) {
        this.leftside.or(formulas);
    }

    @Override
    public void addRight(Formula wff) {
        this.rightside.add(wff);
    }

    public void addRight(BitSetOfFormulas formulas) {
        this.rightside.or(formulas);
    }

    @Override
    public boolean containsLeft(Formula wff) {
        return this.leftside.contains(wff);
    }

    @Override
    public boolean containsLeft(FormulaType type) {
        return this.leftside.containsFormulaOfType(type);
    }

    @Override
    public boolean containsRight(Formula wff) {
        return this.rightside.contains(wff);
    }

    @Override
    public boolean containsRight(FormulaType type) {
        return this.rightside.containsFormulaOfType(type);
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        return this.leftside.getFirst(formulaType);
    }

    @Override
    public Collection<Formula> getLeftFormulas() {
        return this.leftside.getAllFormulas();
    }

    @Override
    public Collection<Formula> getLeftFormulas(FormulaType formulaType) {
        return this.leftside.getAllFormulas(formulaType);
    }

    @Override
    public Formula getRight(FormulaType formulaType) {
        return this.rightside.getFirst(formulaType);
    }

    @Override
    public Collection<Formula> getRightFormulas() {
        return this.rightside.getAllFormulas();
    }

    @Override
    public Collection<Formula> getRightFormulas(FormulaType formulaType) {
        return this.rightside.getAllFormulas(formulaType);
    }

    @Override
    public boolean isEmpty() {
        return this.leftside.isEmpty() && this.rightside.isEmpty();
    }

    @Override
    public boolean isIdentityAxiom() {
        return this.leftside.intersects(this.rightside);
    }

    @Override
    public boolean isLeftSideEmpty() {
        return this.leftside.isEmpty();
    }

    @Override
    public boolean isRightSideEmpty() {
        return this.rightside.isEmpty();
    }

    public BitSetOfFormulas leftSide() {
        return this.leftside.clone();
    }

    public int leftSideCardinality() {
        return this.leftside.cardinality();
    }

    public BitSetOfFormulas rightSide() {
        return this.rightside.clone();
    }

    public int rigthSideCardinality() {
        return this.rightside.cardinality();
    }

    @Override
    public boolean removeLeft(Formula wff) {
        return this.leftside.remove(wff);
    }

    @Override
    public boolean removeRight(Formula wff) {
        return this.rightside.remove(wff);
    }

    @Override
    public SequentOnBSF clone() {
        try {
            SequentOnBSF result = (SequentOnBSF)super.clone();
            result.formulaFactory = this.formulaFactory;
            result.leftside = this.leftside.clone();
            result.rightside = this.rightside.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError(e.getMessage());
        }
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        return String.valueOf(this.toString(this.getLeftFormulas())) + "==>\n" + this.toString(this.getRightFormulas());
    }

    private String toString(Collection<Formula> list) {
        if (list == null) {
            return "";
        }
        Iterator<Formula> it = list.iterator();
        String str = it.next().format();
        while (it.hasNext()) {
            str = String.valueOf(str) + ", " + it.next().format();
        }
        return str;
    }

    public FormulaFactory getFormulaFactory() {
        return this.formulaFactory;
    }

    @Override
    public void stablePart() {
        this.clearRight();
    }

    @Override
    public void clearLeft() {
        this.leftside.clear();
    }

    @Override
    public void clearRight() {
        this.rightside.clear();
    }

    @Override
    public void addLeft(Collection<Formula> formulas) {
        for (Formula formula : formulas) {
            this.addLeft(formula);
        }
    }

    @Override
    public void addRight(Collection<Formula> formulas) {
        for (Formula formula : formulas) {
            this.addRight(formula);
        }
    }

    @Override
    public Iterator<Formula> leftSideIterator() {
        return this.leftside.iterator();
    }

    @Override
    public Iterator<Formula> rigtSideIterator() {
        return this.rightside.iterator();
    }
}

