/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.AbstractCompoundFormula;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.Substitution;

class FormulaOr
extends AbstractCompoundFormula {
    protected FormulaOr(FormulaFactory formulaFactory, Formula left, Formula right) {
        super(formulaFactory, PropositionalConnective.OR, new Formula[]{left, right}, left, right);
    }

    @Override
    protected Formula computeBooleanSimplification() {
        Formula newRight;
        Formula newLeft = this.left.calculateBooleanSimplification();
        if (newLeft.equals(newRight = this.right.calculateBooleanSimplification())) {
            return newLeft;
        }
        if (newLeft.isTrue()) {
            return newLeft;
        }
        if (newLeft.isFalse()) {
            return newRight;
        }
        if (newRight.isTrue()) {
            return newRight;
        }
        if (newRight.isFalse()) {
            return newLeft;
        }
        return this.formulaFactory.buildCompound(this.mainConnective(), newLeft, newRight);
    }

    @Override
    protected Formula computePartialSubstitution(Substitution subst) {
        return this.formulaFactory.buildCompound(this.mainConnective(), this.left.applyIntuitionisticPartialSubstitution(subst), this.right.applyIntuitionisticPartialSubstitution(subst));
    }

    @Override
    public FormulaType getFormulaType() {
        return FormulaType.OR_WFF;
    }
}

