/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.problems;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Scanner;
import java.util.regex.Pattern;
import jtabwbx.problems.Log;

class ILTPProblemLexer {
    private static final String PATTERN = "(\\s+)|(&|\\||~|<=>|=>)|(\\.|,|\\(|\\))|([a-z][_a-zA-Z0-9]*)|(%.*)|.";
    private static int GROUP_WHITESPACES = 1;
    private static int GROUP_OPERATORS = 2;
    private static int GROUP_SEPARATORS = 3;
    private static int GROUP_LOWER_NAME = 4;
    private static int GROUP_INFO_COMMENT = 5;
    private Pattern pattern;
    private final Log LOG;
    private int currentLine = 0;
    private boolean verbose;
    private Scanner scanner;

    public ILTPProblemLexer(String s) {
        this(new StringReader(s));
    }

    public ILTPProblemLexer(Reader reader) {
        this.scanner = new Scanner(reader);
        this.LOG = new Log();
        this.pattern = Pattern.compile(PATTERN);
        this.verbose = false;
    }

    private void updateLineNumber(String white) {
        int i = white.indexOf(10, 0);
        while (i >= 0) {
            ++this.currentLine;
            i = white.indexOf(10, i + 1);
        }
    }

    public Token nextToken() {
        Token token = this._nextToken();
        if (this.verbose) {
            this.LOG.info(String.format("--LEXER: Token = %s", token.toString()));
        }
        return token;
    }

    private Token _nextToken() {
        if (this.scanner.findWithinHorizon(this.pattern, 0) == null) {
            return new Token(TokenType.EOF, "<EOF>");
        }
        String lastLexeme = this.scanner.match().group(0);
        if (this.scanner.match().start(GROUP_WHITESPACES) != -1) {
            this.updateLineNumber(lastLexeme);
            return this._nextToken();
        }
        if (this.scanner.match().start(GROUP_OPERATORS) != -1) {
            return new Token(TokenType.OPERATOR, lastLexeme);
        }
        if (this.scanner.match().start(GROUP_SEPARATORS) != -1) {
            return new Token(TokenType.SEPARATOR, lastLexeme);
        }
        if (this.scanner.match().start(GROUP_LOWER_NAME) != -1) {
            return new Token(TokenType.LOWER_NAME, lastLexeme);
        }
        if (this.scanner.match().start(GROUP_INFO_COMMENT) != -1) {
            return new Token(TokenType.INFO_COMMENT, lastLexeme);
        }
        return new Token(TokenType.ERROR, lastLexeme);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static void main(String[] args) {
        try {
            Token t;
            FileReader reader = new FileReader(args[0]);
            ILTPProblemLexer lexer = new ILTPProblemLexer(reader);
            do {
                t = lexer.nextToken();
                System.out.println(t);
            } while (t.type != TokenType.EOF);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    static class Token {
        private TokenType type;
        private String text;
        Location begin;
        Location end;

        public Token(TokenType type, String data) {
            this.type = type;
            this.text = data;
        }

        public String toString() {
            return String.format("(%s, %s)", this.type.name(), this.text);
        }

        public TokenType getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        class Location {
            public final int line;
            public final int column;

            public Location(int line, int column) {
                this.line = line;
                this.column = column;
            }

            public String toString() {
                return String.valueOf(this.line) + ":" + this.column;
            }
        }
    }

    static enum TokenType {
        OPERATOR,
        SEPARATOR,
        LOWER_NAME,
        INFO_COMMENT,
        ERROR,
        EOF;

    }
}

