/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.modal.formula;

import java.util.Stack;
import jtabwb.util.ImplementationError;
import jtabwbx.modal.basic.ModalConnective;
import jtabwbx.modal.formula.ModalFormula;
import jtabwbx.modal.formula.ModalFormulaFactory;
import jtabwbx.modal.parser.ModalWffBaseListener;
import jtabwbx.modal.parser.ModalWffParser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

class FromParseTreeFormulaBuilder
extends ModalWffBaseListener {
    private Stack<ModalFormula> stack;
    private ModalFormulaFactory formulaFactory;

    public FromParseTreeFormulaBuilder(ModalFormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
    }

    ModalFormula buildFrom(ParseTree tree) {
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)this, tree);
        if (this.stack.size() == 1) {
            ModalFormula wff = this.stack.pop();
            this.stack = null;
            return wff;
        }
        throw new ImplementationError("Something wrong in parse tree walking.");
    }

    @Override
    public void enterModalFormula(ModalWffParser.ModalFormulaContext ctx) {
        this.stack = new Stack();
    }

    @Override
    public void exitProp(ModalWffParser.PropContext ctx) {
        this.stack.push(this.formulaFactory.buildAtomic(ctx.getText()));
    }

    @Override
    public void exitAnd(ModalWffParser.AndContext ctx) {
        ModalFormula right = this.stack.pop();
        ModalFormula left = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(ModalConnective.AND, left, right));
    }

    @Override
    public void exitOr(ModalWffParser.OrContext ctx) {
        ModalFormula right = this.stack.pop();
        ModalFormula left = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(ModalConnective.OR, left, right));
    }

    @Override
    public void exitImp(ModalWffParser.ImpContext ctx) {
        ModalFormula right = this.stack.pop();
        ModalFormula left = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(ModalConnective.IMPLIES, left, right));
    }

    @Override
    public void exitEq(ModalWffParser.EqContext ctx) {
        ModalFormula right = this.stack.pop();
        ModalFormula left = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(ModalConnective.EQ, left, right));
    }

    @Override
    public void exitNeg(ModalWffParser.NegContext ctx) {
        ModalFormula subf = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(ModalConnective.NOT, subf));
    }

    @Override
    public void exitBox(ModalWffParser.BoxContext ctx) {
        ModalFormula subf = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(ModalConnective.BOX, subf));
    }

    @Override
    public void exitDia(ModalWffParser.DiaContext ctx) {
        ModalFormula subf = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(ModalConnective.DIA, subf));
    }

    @Override
    public void exitPar(ModalWffParser.ParContext ctx) {
    }
}

