/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.modal.basic;

import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.modal.formula.ModalFormula;

public enum ModalFormulaType {
    ATOMIC_WFF,
    AND_WFF,
    OR_WFF,
    IMPLIES_WFF,
    NOT_WFF,
    EQ_WFF,
    BOX_WFF,
    DIA_WFF;


    public static ModalFormulaType getFormulaType(ModalFormula wff) {
        if (wff.isAtomic()) {
            return ATOMIC_WFF;
        }
        switch (wff.mainConnective()) {
            case AND: {
                return AND_WFF;
            }
            case OR: {
                return OR_WFF;
            }
            case IMPLIES: {
                return IMPLIES_WFF;
            }
            case NOT: {
                return NOT_WFF;
            }
            case EQ: {
                return EQ_WFF;
            }
            case BOX: {
                return BOX_WFF;
            }
            case DIA: {
                return DIA_WFF;
            }
        }
        throw new CaseNotImplementedImplementationError(wff.mainConnective().getName());
    }
}

