/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.launcher;

import ferram.CLIOptionsSupport.CLIOptionsSupport;
import java.util.LinkedList;
import jtabwb.engine.Engine;
import jtabwb.launcher.ConfiguredProblemDescriptioReader;
import jtabwb.launcher.ConfiguredTheoremProver;
import jtabwb.launcher.Launcher;
import jtabwb.launcher.LauncherExecutionException;
import jtabwb.launcher.LauncherOptionDefinitionException;
import jtabwb.launcher.Log;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

class CmdLineOptions {
    private final Log LOG;
    private CLIOptionsSupport incomp = new CLIOptionsSupport();
    Launcher.LaunchConfiguration configuration;

    public CmdLineOptions(Launcher.LaunchConfiguration configuration) {
        this.LOG = new Log();
        this.incomp = new CLIOptionsSupport();
        this.configuration = configuration;
        OptNames.defineIncompatibility(this.incomp);
    }

    void defineCmdLineOptions() {
        LinkedList<Option> lo = new LinkedList<Option>();
        lo.add(Option.builder((String)OptNames.HELP).desc("Print usage message and exit.").build());
        lo.add(Option.builder((String)OptNames.INPUT).desc("Read the formula from standard input.").build());
        lo.add(Option.builder().longOpt(OptNames.LATEX_CTREE).desc("Save the LaTeX of the c-trees generated by the proof-search in the specified file.").build());
        lo.add(Option.builder().longOpt(OptNames.LATEX_PROOF).desc("Save the LaTeX of the proof generated by a successful proof-search in the specified file.").build());
        if (this.configuration.availableProvers.size() > 1) {
            lo.add(Option.builder().longOpt(OptNames.LIST_PROVERS).desc("Detailed description of available provers.").build());
            if (this.configuration.availableProvers.size() > 1) {
                lo.add(Option.builder((String)OptNames.PROVER).hasArg().argName("name").desc(String.format("Set the theorem prover, if this option is not set the default is used. Available provers (* is default): %s", this.configuration.availableProvers.getNames())).build());
            }
        }
        if (this.configuration.availableReaders.size() > 1) {
            lo.add(Option.builder((String)OptNames.READER).hasArg().argName("name").desc(String.format("Set the formula reader, if this option is not set the default is used. Available readers (* is default): %s", this.configuration.availableReaders.getNames())).build());
            lo.add(Option.builder().longOpt(OptNames.LIST_READERS).desc("Detailed description of available readers.").build());
        }
        lo.add(Option.builder().longOpt(OptNames.LOG).desc("Save execution details in the the specified file.").build());
        lo.add(Option.builder().longOpt(OptNames.LOG_TIME).desc("Save time execution details in the specified file.").build());
        lo.add(Option.builder().longOpt(OptNames.SAVE_TRACE).desc("Save the trace of the proof-search in the specified file.").build());
        lo.add(Option.builder((String)OptNames.VERBOSE).desc("Print detailed informations on the proof process.").build());
        lo.add(Option.builder().longOpt(OptNames.TESTSET).hasArg(true).argName("test-name").desc("Execute a test on the problems specified on the command line. test-name is used to name the log files.").build());
        lo.add(Option.builder().longOpt(OptNames.LOG_DIR).hasArg(true).argName("filename").desc("Defines the directory used to save log files.").build());
        lo.add(Option.builder().longOpt(OptNames.F3_TIME_STR).hasArg(false).desc("Prints on the standard output timing info in f3 format.").build());
        lo.add(Option.builder().longOpt(OptNames.JTABWB_TIME_STR).hasArg(false).desc("Prints on the standard output timing info in JTabWb format.").build());
        for (Option opt : lo) {
            if (this.configuration.cmdLineOptions.getOption(opt.getOpt()) != null || this.configuration.cmdLineOptions.getOption(opt.getLongOpt()) != null) {
                throw new LauncherOptionDefinitionException(String.format("ERROR - setCmdLineOptions - option [%s] is one of reserved launcher options.", opt.getOpt()));
            }
            this.configuration.cmdLineOptions.addOption(opt);
        }
    }

    Launcher.LaunchConfiguration processComdLineOptions(String[] args) {
        this.defineCmdLineOptions();
        DefaultParser parser = new DefaultParser();
        try {
            this.configuration.commandLine = parser.parse(this.configuration.cmdLineOptions, args, false);
        }
        catch (ParseException exp) {
            this.LOG.error("Command line parsing failed: %s", exp.getMessage());
            System.exit(1);
        }
        if (this.incomp.hasIncompatibleOptions(this.configuration.commandLine)) {
            this.LOG.error(this.incomp.firstIncompatibilityDescription(this.configuration.commandLine), new Object[0]);
            System.exit(1);
        }
        if (this.configuration.commandLine.hasOption(OptNames.HELP)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(this.configuration.launcherClassName, "Laucher for the prover.", this.configuration.cmdLineOptions, "", true);
            System.exit(0);
        }
        if (this.configuration.commandLine.hasOption(OptNames.LIST_READERS)) {
            this.LOG.info("Available readers (* is the default value):\n%s", this.configuration.availableReaders.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (this.configuration.commandLine.hasOption(OptNames.LIST_PROVERS)) {
            this.LOG.info("Available provers (* is the default value):\n%s", this.configuration.availableProvers.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (this.configuration.commandLine.hasOption(OptNames.INPUT)) {
            if (this.configuration.stdinReader == null) {
                throw new LauncherExecutionException(String.format("The problem reader for standard input is undefined, define it using the configStandardInputReader() method.", new Object[0]));
            }
            this.configuration.readFromStandardInput = true;
        }
        if (this.configuration.commandLine.hasOption(OptNames.LATEX_PROOF)) {
            this.configuration.engineExecutionMode = Engine.ExecutionMode.ENGINE_TRACE;
            this.configuration.generateLatexOfProof = true;
        }
        if (this.configuration.commandLine.hasOption(OptNames.LATEX_CTREE)) {
            this.configuration.engineExecutionMode = Engine.ExecutionMode.ENGINE_TRACE;
            this.configuration.generateLatexOfCtrees = true;
        }
        if (this.configuration.commandLine.hasOption(OptNames.LOG)) {
            this.configuration.generateLogFile = true;
        }
        if (this.configuration.commandLine.hasOption(OptNames.LOG_TIME)) {
            this.configuration.generateLogTimeFile = true;
        }
        if (this.configuration.commandLine.hasOption(OptNames.SAVE_TRACE)) {
            this.configuration.engineExecutionMode = Engine.ExecutionMode.ENGINE_TRACE;
            this.configuration.saveTrace = true;
        }
        if (this.configuration.commandLine.hasOption(OptNames.LOG_DIR)) {
            this.configuration.logDirAbsolutePath = this.configuration.commandLine.getOptionValue(OptNames.LOG_DIR);
        }
        if (this.configuration.commandLine.hasOption(OptNames.TESTSET)) {
            this.configuration.testsetmode = true;
            this.configuration.testsetName = this.configuration.commandLine.getOptionValue(OptNames.TESTSET);
        }
        if (this.configuration.commandLine.hasOption(OptNames.F3_TIME_STR)) {
            this.configuration.generatef3TimeStr = true;
        }
        if (this.configuration.commandLine.hasOption(OptNames.JTABWB_TIME_STR)) {
            this.configuration.generateJTabWbTimeStr = true;
        }
        if (this.configuration.commandLine.hasOption(OptNames.READER)) {
            String readerName = this.configuration.commandLine.getOptionValue(OptNames.READER);
            ConfiguredProblemDescriptioReader reader = this.configuration.availableReaders.searchReaderByName(readerName);
            if (reader != null) {
                this.configuration.fileReader = reader;
            } else {
                this.LOG.error("There is not a problem description reader with name [%s].", readerName);
                System.exit(1);
            }
        } else {
            this.configuration.fileReader = this.configuration.availableReaders.getDefaultReader();
        }
        if (this.configuration.commandLine.hasOption(OptNames.PROVER)) {
            String proverName = this.configuration.commandLine.getOptionValue(OptNames.PROVER);
            ConfiguredTheoremProver prover = this.configuration.availableProvers.searchProverByName(proverName);
            if (prover != null) {
                this.configuration.selectedProver = prover;
            } else {
                this.LOG.error("There is not a prover with name [%s].", proverName);
                System.exit(1);
            }
        } else {
            this.configuration.selectedProver = this.configuration.availableProvers.getDefaultProver();
        }
        if (this.configuration.commandLine.hasOption(OptNames.VERBOSE)) {
            this.configuration.verboseExecutionMode = true;
            this.configuration.engineExecutionMode = Engine.ExecutionMode.ENGINE_VERBOSE;
        }
        return this.configuration;
    }

    static class OptNames {
        static String HELP = "h";
        static String INPUT = "i";
        static String READER = "r";
        static String PROVER = "p";
        static String VERBOSE = "v";
        static String F3_TIME_STR = "f3time";
        static String JTABWB_TIME_STR = "jtabwbtime";
        static String LATEX_CTREE = "latex-ctrees";
        static String LATEX_PROOF = "latex-proof";
        static String LIST_READERS = "readers";
        static String LIST_PROVERS = "provers";
        static String SAVE_TRACE = "save-trace";
        static String LOG = "log";
        static String LOG_TIME = "time";
        static String TESTSET = "testset";
        static String LOG_DIR = "logdir";

        OptNames() {
        }

        static void defineIncompatibility(CLIOptionsSupport incomp) {
            incomp.addIncompatibility(VERBOSE, TESTSET);
            incomp.addIncompatibility(VERBOSE, LATEX_CTREE);
            incomp.addIncompatibility(VERBOSE, LATEX_PROOF);
            incomp.addIncompatibility(VERBOSE, SAVE_TRACE);
            incomp.addIncompatibility(TESTSET, VERBOSE);
            incomp.addIncompatibility(TESTSET, LATEX_CTREE);
            incomp.addIncompatibility(TESTSET, LATEX_PROOF);
            incomp.addIncompatibility(TESTSET, SAVE_TRACE);
            incomp.addIncompatibility(TESTSET, F3_TIME_STR);
            incomp.addIncompatibility(READER, INPUT);
        }
    }
}

